package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteResourcePermissionRequest(
    actionType: Optional[zio.aws.ssmsap.model.PermissionActionType] =
      Optional.Absent,
    sourceResourceArn: Optional[Arn] = Optional.Absent,
    resourceArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionRequest = {
    import DeleteResourcePermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionRequest
      .builder()
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(
        sourceResourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.sourceResourceArn)
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ssmsap.model.DeleteResourcePermissionRequest.ReadOnly =
    zio.aws.ssmsap.model.DeleteResourcePermissionRequest.wrap(buildAwsValue())
}
object DeleteResourcePermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.DeleteResourcePermissionRequest =
      zio.aws.ssmsap.model.DeleteResourcePermissionRequest(
        actionType.map(value => value),
        sourceResourceArn.map(value => value),
        resourceArn
      )
    def actionType: Optional[zio.aws.ssmsap.model.PermissionActionType]
    def sourceResourceArn: Optional[Arn]
    def resourceArn: Arn
    def getActionType
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.PermissionActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getSourceResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("sourceResourceArn", sourceResourceArn)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionRequest
  ) extends zio.aws.ssmsap.model.DeleteResourcePermissionRequest.ReadOnly {
    override val actionType
        : Optional[zio.aws.ssmsap.model.PermissionActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionType())
        .map(value => zio.aws.ssmsap.model.PermissionActionType.wrap(value))
    override val sourceResourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceResourceArn())
      .map(value => zio.aws.ssmsap.model.primitives.Arn(value))
    override val resourceArn: Arn =
      zio.aws.ssmsap.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionRequest
  ): zio.aws.ssmsap.model.DeleteResourcePermissionRequest.ReadOnly =
    new Wrapper(impl)
}
