package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{ComponentId, ApplicationId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetComponentRequest(
    applicationId: ApplicationId,
    componentId: ComponentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.GetComponentRequest = {
    import GetComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.GetComponentRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .componentId(ComponentId.unwrap(componentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.GetComponentRequest.ReadOnly =
    zio.aws.ssmsap.model.GetComponentRequest.wrap(buildAwsValue())
}
object GetComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.GetComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.GetComponentRequest =
      zio.aws.ssmsap.model.GetComponentRequest(applicationId, componentId)
    def applicationId: ApplicationId
    def componentId: ComponentId
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getComponentId: ZIO[Any, Nothing, ComponentId] =
      ZIO.succeed(componentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.GetComponentRequest
  ) extends zio.aws.ssmsap.model.GetComponentRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.ssmsap.model.primitives.ApplicationId(impl.applicationId())
    override val componentId: ComponentId =
      zio.aws.ssmsap.model.primitives.ComponentId(impl.componentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.GetComponentRequest
  ): zio.aws.ssmsap.model.GetComponentRequest.ReadOnly = new Wrapper(impl)
}
