package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters._
sealed trait CredentialType {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.CredentialType
}
object CredentialType {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.CredentialType
  ): zio.aws.ssmsap.model.CredentialType = value match {
    case software.amazon.awssdk.services.ssmsap.model.CredentialType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.CredentialType.ADMIN =>
      val r = ADMIN
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.CredentialType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.CredentialType =
      software.amazon.awssdk.services.ssmsap.model.CredentialType.UNKNOWN_TO_SDK_VERSION
  }
  case object ADMIN extends zio.aws.ssmsap.model.CredentialType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.CredentialType =
      software.amazon.awssdk.services.ssmsap.model.CredentialType.ADMIN
  }
}
