package zio.aws.ssmsap.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutResourcePermissionResponse(
    policy: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionResponse = {
    import PutResourcePermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionResponse
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.PutResourcePermissionResponse.ReadOnly =
    zio.aws.ssmsap.model.PutResourcePermissionResponse.wrap(buildAwsValue())
}
object PutResourcePermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.PutResourcePermissionResponse =
      zio.aws.ssmsap.model
        .PutResourcePermissionResponse(policy.map(value => value))
    def policy: Optional[String]
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionResponse
  ) extends zio.aws.ssmsap.model.PutResourcePermissionResponse.ReadOnly {
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.PutResourcePermissionResponse
  ): zio.aws.ssmsap.model.PutResourcePermissionResponse.ReadOnly = new Wrapper(
    impl
  )
}
