package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters._
sealed trait DatabaseStatus {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.DatabaseStatus
}
object DatabaseStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.DatabaseStatus
  ): zio.aws.ssmsap.model.DatabaseStatus = value match {
    case software.amazon.awssdk.services.ssmsap.model.DatabaseStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.DatabaseStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.ssmsap.model.DatabaseStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.ssmsap.model.DatabaseStatus.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.ssmsap.model.DatabaseStatus.WARNING =>
      val r = WARNING
      r
    case software.amazon.awssdk.services.ssmsap.model.DatabaseStatus.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.DatabaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.DatabaseStatus =
      software.amazon.awssdk.services.ssmsap.model.DatabaseStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.ssmsap.model.DatabaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.DatabaseStatus =
      software.amazon.awssdk.services.ssmsap.model.DatabaseStatus.RUNNING
  }
  case object STARTING extends zio.aws.ssmsap.model.DatabaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.DatabaseStatus =
      software.amazon.awssdk.services.ssmsap.model.DatabaseStatus.STARTING
  }
  case object STOPPED extends zio.aws.ssmsap.model.DatabaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.DatabaseStatus =
      software.amazon.awssdk.services.ssmsap.model.DatabaseStatus.STOPPED
  }
  case object WARNING extends zio.aws.ssmsap.model.DatabaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.DatabaseStatus =
      software.amazon.awssdk.services.ssmsap.model.DatabaseStatus.WARNING
  }
  case object UNKNOWN extends zio.aws.ssmsap.model.DatabaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.DatabaseStatus =
      software.amazon.awssdk.services.ssmsap.model.DatabaseStatus.UNKNOWN
  }
}
