package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters._
sealed trait OperationStatus {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.OperationStatus
}
object OperationStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.OperationStatus
  ): zio.aws.ssmsap.model.OperationStatus = value match {
    case software.amazon.awssdk.services.ssmsap.model.OperationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.OperationStatus.INPROGRESS =>
      val r = INPROGRESS
      r
    case software.amazon.awssdk.services.ssmsap.model.OperationStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.ssmsap.model.OperationStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.OperationStatus =
      software.amazon.awssdk.services.ssmsap.model.OperationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INPROGRESS extends zio.aws.ssmsap.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.OperationStatus =
      software.amazon.awssdk.services.ssmsap.model.OperationStatus.INPROGRESS
  }
  case object SUCCESS extends zio.aws.ssmsap.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.OperationStatus =
      software.amazon.awssdk.services.ssmsap.model.OperationStatus.SUCCESS
  }
  case object ERROR extends zio.aws.ssmsap.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.OperationStatus =
      software.amazon.awssdk.services.ssmsap.model.OperationStatus.ERROR
  }
}
