package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters._
sealed trait BackintMode {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.BackintMode
}
object BackintMode {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.BackintMode
  ): zio.aws.ssmsap.model.BackintMode = value match {
    case software.amazon.awssdk.services.ssmsap.model.BackintMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.BackintMode.AWS_BACKUP =>
      val r = AWSBackup
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.BackintMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.BackintMode =
      software.amazon.awssdk.services.ssmsap.model.BackintMode.UNKNOWN_TO_SDK_VERSION
  }
  case object AWSBackup extends zio.aws.ssmsap.model.BackintMode {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.BackintMode =
      software.amazon.awssdk.services.ssmsap.model.BackintMode.AWS_BACKUP
  }
}
