package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{TagValue, TagKey, SsmSapArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: SsmSapArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.TagResourceRequest
      .builder()
      .resourceArn(SsmSapArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.TagResourceRequest.ReadOnly =
    zio.aws.ssmsap.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.TagResourceRequest =
      zio.aws.ssmsap.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: SsmSapArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, SsmSapArn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.TagResourceRequest
  ) extends zio.aws.ssmsap.model.TagResourceRequest.ReadOnly {
    override val resourceArn: SsmSapArn =
      zio.aws.ssmsap.model.primitives.SsmSapArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.ssmsap.model.primitives
          .TagKey(key) -> zio.aws.ssmsap.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.TagResourceRequest
  ): zio.aws.ssmsap.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
