package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{TagKey, SsmSapArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: SsmSapArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.UntagResourceRequest
      .builder()
      .resourceArn(SsmSapArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.UntagResourceRequest.ReadOnly =
    zio.aws.ssmsap.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.UntagResourceRequest =
      zio.aws.ssmsap.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: SsmSapArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, SsmSapArn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.UntagResourceRequest
  ) extends zio.aws.ssmsap.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: SsmSapArn =
      zio.aws.ssmsap.model.primitives.SsmSapArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.ssmsap.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.UntagResourceRequest
  ): zio.aws.ssmsap.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
