package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.OperationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetOperationRequest(operationId: OperationId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.GetOperationRequest = {
    import GetOperationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.GetOperationRequest
      .builder()
      .operationId(OperationId.unwrap(operationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.GetOperationRequest.ReadOnly =
    zio.aws.ssmsap.model.GetOperationRequest.wrap(buildAwsValue())
}
object GetOperationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.GetOperationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.GetOperationRequest =
      zio.aws.ssmsap.model.GetOperationRequest(operationId)
    def operationId: OperationId
    def getOperationId: ZIO[Any, Nothing, OperationId] =
      ZIO.succeed(operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.GetOperationRequest
  ) extends zio.aws.ssmsap.model.GetOperationRequest.ReadOnly {
    override val operationId: OperationId =
      zio.aws.ssmsap.model.primitives.OperationId(impl.operationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.GetOperationRequest
  ): zio.aws.ssmsap.model.GetOperationRequest.ReadOnly = new Wrapper(impl)
}
