package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetComponentResponse(
    component: Optional[zio.aws.ssmsap.model.Component] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.GetComponentResponse = {
    import GetComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.GetComponentResponse
      .builder()
      .optionallyWith(component.map(value => value.buildAwsValue()))(
        _.component
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.GetComponentResponse.ReadOnly =
    zio.aws.ssmsap.model.GetComponentResponse.wrap(buildAwsValue())
}
object GetComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.GetComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.GetComponentResponse =
      zio.aws.ssmsap.model.GetComponentResponse(
        component.map(value => value.asEditable),
        tags.map(value => value)
      )
    def component: Optional[zio.aws.ssmsap.model.Component.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getComponent
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.Component.ReadOnly] =
      AwsError.unwrapOptionField("component", component)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.GetComponentResponse
  ) extends zio.aws.ssmsap.model.GetComponentResponse.ReadOnly {
    override val component: Optional[zio.aws.ssmsap.model.Component.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.component())
        .map(value => zio.aws.ssmsap.model.Component.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssmsap.model.primitives
              .TagKey(key) -> zio.aws.ssmsap.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.GetComponentResponse
  ): zio.aws.ssmsap.model.GetComponentResponse.ReadOnly = new Wrapper(impl)
}
