package zio.aws.ssmsap.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Host(
    hostName: Optional[String] = Optional.Absent,
    hostIp: Optional[String] = Optional.Absent,
    ec2InstanceId: Optional[String] = Optional.Absent,
    instanceId: Optional[String] = Optional.Absent,
    hostRole: Optional[zio.aws.ssmsap.model.HostRole] = Optional.Absent,
    osVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssmsap.model.Host = {
    import Host.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.Host
      .builder()
      .optionallyWith(hostName.map(value => value: java.lang.String))(
        _.hostName
      )
      .optionallyWith(hostIp.map(value => value: java.lang.String))(_.hostIp)
      .optionallyWith(ec2InstanceId.map(value => value: java.lang.String))(
        _.ec2InstanceId
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(hostRole.map(value => value.unwrap))(_.hostRole)
      .optionallyWith(osVersion.map(value => value: java.lang.String))(
        _.osVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.Host.ReadOnly =
    zio.aws.ssmsap.model.Host.wrap(buildAwsValue())
}
object Host {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssmsap.model.Host] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.Host = zio.aws.ssmsap.model.Host(
      hostName.map(value => value),
      hostIp.map(value => value),
      ec2InstanceId.map(value => value),
      instanceId.map(value => value),
      hostRole.map(value => value),
      osVersion.map(value => value)
    )
    def hostName: Optional[String]
    def hostIp: Optional[String]
    def ec2InstanceId: Optional[String]
    def instanceId: Optional[String]
    def hostRole: Optional[zio.aws.ssmsap.model.HostRole]
    def osVersion: Optional[String]
    def getHostName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostName", hostName)
    def getHostIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostIp", hostIp)
    def getEc2InstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getHostRole: ZIO[Any, AwsError, zio.aws.ssmsap.model.HostRole] =
      AwsError.unwrapOptionField("hostRole", hostRole)
    def getOsVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("osVersion", osVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.Host
  ) extends zio.aws.ssmsap.model.Host.ReadOnly {
    override val hostName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostName())
      .map(value => value: String)
    override val hostIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostIp())
      .map(value => value: String)
    override val ec2InstanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2InstanceId())
      .map(value => value: String)
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val hostRole: Optional[zio.aws.ssmsap.model.HostRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostRole())
        .map(value => zio.aws.ssmsap.model.HostRole.wrap(value))
    override val osVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.osVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.Host
  ): zio.aws.ssmsap.model.Host.ReadOnly = new Wrapper(impl)
}
