package zio.aws.ssmsap.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmsap.model.primitives.{
  DatabaseId,
  SsmSapArn,
  Timestamp,
  ComponentId,
  ApplicationId
}
import scala.jdk.CollectionConverters._
final case class Component(
    componentId: Optional[ComponentId] = Optional.Absent,
    parentComponent: Optional[ComponentId] = Optional.Absent,
    childComponents: Optional[Iterable[ComponentId]] = Optional.Absent,
    applicationId: Optional[ApplicationId] = Optional.Absent,
    componentType: Optional[zio.aws.ssmsap.model.ComponentType] =
      Optional.Absent,
    status: Optional[zio.aws.ssmsap.model.ComponentStatus] = Optional.Absent,
    sapHostname: Optional[String] = Optional.Absent,
    sapKernelVersion: Optional[String] = Optional.Absent,
    hdbVersion: Optional[String] = Optional.Absent,
    resilience: Optional[zio.aws.ssmsap.model.Resilience] = Optional.Absent,
    associatedHost: Optional[zio.aws.ssmsap.model.AssociatedHost] =
      Optional.Absent,
    databases: Optional[Iterable[DatabaseId]] = Optional.Absent,
    hosts: Optional[Iterable[zio.aws.ssmsap.model.Host]] = Optional.Absent,
    primaryHost: Optional[String] = Optional.Absent,
    lastUpdated: Optional[Timestamp] = Optional.Absent,
    arn: Optional[SsmSapArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.Component = {
    import Component.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.Component
      .builder()
      .optionallyWith(
        componentId.map(value => ComponentId.unwrap(value): java.lang.String)
      )(_.componentId)
      .optionallyWith(
        parentComponent.map(value =>
          ComponentId.unwrap(value): java.lang.String
        )
      )(_.parentComponent)
      .optionallyWith(
        childComponents.map(value =>
          value.map { item =>
            ComponentId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.childComponents)
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(componentType.map(value => value.unwrap))(_.componentType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(sapHostname.map(value => value: java.lang.String))(
        _.sapHostname
      )
      .optionallyWith(sapKernelVersion.map(value => value: java.lang.String))(
        _.sapKernelVersion
      )
      .optionallyWith(hdbVersion.map(value => value: java.lang.String))(
        _.hdbVersion
      )
      .optionallyWith(resilience.map(value => value.buildAwsValue()))(
        _.resilience
      )
      .optionallyWith(associatedHost.map(value => value.buildAwsValue()))(
        _.associatedHost
      )
      .optionallyWith(
        databases.map(value =>
          value.map { item =>
            DatabaseId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.databases)
      .optionallyWith(
        hosts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hosts)
      .optionallyWith(primaryHost.map(value => value: java.lang.String))(
        _.primaryHost
      )
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        arn.map(value => SsmSapArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.Component.ReadOnly =
    zio.aws.ssmsap.model.Component.wrap(buildAwsValue())
}
object Component {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssmsap.model.Component] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.Component =
      zio.aws.ssmsap.model.Component(
        componentId.map(value => value),
        parentComponent.map(value => value),
        childComponents.map(value => value),
        applicationId.map(value => value),
        componentType.map(value => value),
        status.map(value => value),
        sapHostname.map(value => value),
        sapKernelVersion.map(value => value),
        hdbVersion.map(value => value),
        resilience.map(value => value.asEditable),
        associatedHost.map(value => value.asEditable),
        databases.map(value => value),
        hosts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        primaryHost.map(value => value),
        lastUpdated.map(value => value),
        arn.map(value => value)
      )
    def componentId: Optional[ComponentId]
    def parentComponent: Optional[ComponentId]
    def childComponents: Optional[List[ComponentId]]
    def applicationId: Optional[ApplicationId]
    def componentType: Optional[zio.aws.ssmsap.model.ComponentType]
    def status: Optional[zio.aws.ssmsap.model.ComponentStatus]
    def sapHostname: Optional[String]
    def sapKernelVersion: Optional[String]
    def hdbVersion: Optional[String]
    def resilience: Optional[zio.aws.ssmsap.model.Resilience.ReadOnly]
    def associatedHost: Optional[zio.aws.ssmsap.model.AssociatedHost.ReadOnly]
    def databases: Optional[List[DatabaseId]]
    def hosts: Optional[List[zio.aws.ssmsap.model.Host.ReadOnly]]
    def primaryHost: Optional[String]
    def lastUpdated: Optional[Timestamp]
    def arn: Optional[SsmSapArn]
    def getComponentId: ZIO[Any, AwsError, ComponentId] =
      AwsError.unwrapOptionField("componentId", componentId)
    def getParentComponent: ZIO[Any, AwsError, ComponentId] =
      AwsError.unwrapOptionField("parentComponent", parentComponent)
    def getChildComponents: ZIO[Any, AwsError, List[ComponentId]] =
      AwsError.unwrapOptionField("childComponents", childComponents)
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getComponentType
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.ComponentType] =
      AwsError.unwrapOptionField("componentType", componentType)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssmsap.model.ComponentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSapHostname: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sapHostname", sapHostname)
    def getSapKernelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sapKernelVersion", sapKernelVersion)
    def getHdbVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hdbVersion", hdbVersion)
    def getResilience
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.Resilience.ReadOnly] =
      AwsError.unwrapOptionField("resilience", resilience)
    def getAssociatedHost
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.AssociatedHost.ReadOnly] =
      AwsError.unwrapOptionField("associatedHost", associatedHost)
    def getDatabases: ZIO[Any, AwsError, List[DatabaseId]] =
      AwsError.unwrapOptionField("databases", databases)
    def getHosts: ZIO[Any, AwsError, List[zio.aws.ssmsap.model.Host.ReadOnly]] =
      AwsError.unwrapOptionField("hosts", hosts)
    def getPrimaryHost: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("primaryHost", primaryHost)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getArn: ZIO[Any, AwsError, SsmSapArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.Component
  ) extends zio.aws.ssmsap.model.Component.ReadOnly {
    override val componentId: Optional[ComponentId] = zio.aws.core.internal
      .optionalFromNullable(impl.componentId())
      .map(value => zio.aws.ssmsap.model.primitives.ComponentId(value))
    override val parentComponent: Optional[ComponentId] = zio.aws.core.internal
      .optionalFromNullable(impl.parentComponent())
      .map(value => zio.aws.ssmsap.model.primitives.ComponentId(value))
    override val childComponents: Optional[List[ComponentId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childComponents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmsap.model.primitives.ComponentId(item)
          }.toList
        )
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.ssmsap.model.primitives.ApplicationId(value))
    override val componentType: Optional[zio.aws.ssmsap.model.ComponentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentType())
        .map(value => zio.aws.ssmsap.model.ComponentType.wrap(value))
    override val status: Optional[zio.aws.ssmsap.model.ComponentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssmsap.model.ComponentStatus.wrap(value))
    override val sapHostname: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sapHostname())
      .map(value => value: String)
    override val sapKernelVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sapKernelVersion())
      .map(value => value: String)
    override val hdbVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hdbVersion())
      .map(value => value: String)
    override val resilience
        : Optional[zio.aws.ssmsap.model.Resilience.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resilience())
        .map(value => zio.aws.ssmsap.model.Resilience.wrap(value))
    override val associatedHost
        : Optional[zio.aws.ssmsap.model.AssociatedHost.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedHost())
        .map(value => zio.aws.ssmsap.model.AssociatedHost.wrap(value))
    override val databases: Optional[List[DatabaseId]] = zio.aws.core.internal
      .optionalFromNullable(impl.databases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssmsap.model.primitives.DatabaseId(item)
        }.toList
      )
    override val hosts: Optional[List[zio.aws.ssmsap.model.Host.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hosts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmsap.model.Host.wrap(item)
          }.toList
        )
    override val primaryHost: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.primaryHost())
      .map(value => value: String)
    override val lastUpdated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.ssmsap.model.primitives.Timestamp(value))
    override val arn: Optional[SsmSapArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ssmsap.model.primitives.SsmSapArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.Component
  ): zio.aws.ssmsap.model.Component.ReadOnly = new Wrapper(impl)
}
