package zio.aws.ssmsap
import zio.aws.ssmsap.model.ListOperationsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.ssmsap.model.{
  RegisterApplicationRequest,
  StartApplicationRefreshRequest,
  GetOperationRequest,
  ListTagsForResourceRequest,
  GetDatabaseRequest,
  ListDatabasesRequest,
  UpdateApplicationSettingsRequest,
  GetApplicationRequest,
  PutResourcePermissionRequest,
  GetResourcePermissionRequest,
  UntagResourceRequest,
  ListApplicationsRequest,
  ListComponentsRequest,
  DeleteResourcePermissionRequest,
  DeregisterApplicationRequest,
  GetComponentRequest,
  ListOperationsRequest,
  TagResourceRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.ssmsap.SsmSapAsyncClient
object SsmSapMock extends Mock[SsmSap] {
  object ListDatabases
      extends Stream[
        ListDatabasesRequest,
        AwsError,
        zio.aws.ssmsap.model.DatabaseSummary.ReadOnly
      ]
  object ListDatabasesPaginated
      extends Effect[
        ListDatabasesRequest,
        AwsError,
        zio.aws.ssmsap.model.ListDatabasesResponse.ReadOnly
      ]
  object GetApplication
      extends Effect[
        GetApplicationRequest,
        AwsError,
        zio.aws.ssmsap.model.GetApplicationResponse.ReadOnly
      ]
  object RegisterApplication
      extends Effect[
        RegisterApplicationRequest,
        AwsError,
        zio.aws.ssmsap.model.RegisterApplicationResponse.ReadOnly
      ]
  object PutResourcePermission
      extends Effect[
        PutResourcePermissionRequest,
        AwsError,
        zio.aws.ssmsap.model.PutResourcePermissionResponse.ReadOnly
      ]
  object UpdateApplicationSettings
      extends Effect[
        UpdateApplicationSettingsRequest,
        AwsError,
        zio.aws.ssmsap.model.UpdateApplicationSettingsResponse.ReadOnly
      ]
  object ListOperations
      extends Stream[
        ListOperationsRequest,
        AwsError,
        zio.aws.ssmsap.model.Operation.ReadOnly
      ]
  object ListOperationsPaginated
      extends Effect[ListOperationsRequest, AwsError, ReadOnly]
  object ListComponents
      extends Stream[
        ListComponentsRequest,
        AwsError,
        zio.aws.ssmsap.model.ComponentSummary.ReadOnly
      ]
  object ListComponentsPaginated
      extends Effect[
        ListComponentsRequest,
        AwsError,
        zio.aws.ssmsap.model.ListComponentsResponse.ReadOnly
      ]
  object StartApplicationRefresh
      extends Effect[
        StartApplicationRefreshRequest,
        AwsError,
        zio.aws.ssmsap.model.StartApplicationRefreshResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.ssmsap.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteResourcePermission
      extends Effect[
        DeleteResourcePermissionRequest,
        AwsError,
        zio.aws.ssmsap.model.DeleteResourcePermissionResponse.ReadOnly
      ]
  object GetResourcePermission
      extends Effect[
        GetResourcePermissionRequest,
        AwsError,
        zio.aws.ssmsap.model.GetResourcePermissionResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.ssmsap.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.ssmsap.model.TagResourceResponse.ReadOnly
      ]
  object ListApplications
      extends Stream[
        ListApplicationsRequest,
        AwsError,
        zio.aws.ssmsap.model.ApplicationSummary.ReadOnly
      ]
  object ListApplicationsPaginated
      extends Effect[
        ListApplicationsRequest,
        AwsError,
        zio.aws.ssmsap.model.ListApplicationsResponse.ReadOnly
      ]
  object GetOperation
      extends Effect[
        GetOperationRequest,
        AwsError,
        zio.aws.ssmsap.model.GetOperationResponse.ReadOnly
      ]
  object GetDatabase
      extends Effect[
        GetDatabaseRequest,
        AwsError,
        zio.aws.ssmsap.model.GetDatabaseResponse.ReadOnly
      ]
  object GetComponent
      extends Effect[
        GetComponentRequest,
        AwsError,
        zio.aws.ssmsap.model.GetComponentResponse.ReadOnly
      ]
  object DeregisterApplication
      extends Effect[
        DeregisterApplicationRequest,
        AwsError,
        zio.aws.ssmsap.model.DeregisterApplicationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SsmSap] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, SsmSap] { rts =>
        zio.ZIO.succeed {
          new SsmSap {
            val api: SsmSapAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): SsmSap = this
            def listDatabases(request: ListDatabasesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssmsap.model.DatabaseSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDatabases, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDatabasesPaginated(request: ListDatabasesRequest): IO[
              AwsError,
              zio.aws.ssmsap.model.ListDatabasesResponse.ReadOnly
            ] = proxy(ListDatabasesPaginated, request)
            def getApplication(request: GetApplicationRequest): IO[
              AwsError,
              zio.aws.ssmsap.model.GetApplicationResponse.ReadOnly
            ] = proxy(GetApplication, request)
            def registerApplication(request: RegisterApplicationRequest): IO[
              AwsError,
              zio.aws.ssmsap.model.RegisterApplicationResponse.ReadOnly
            ] = proxy(RegisterApplication, request)
            def putResourcePermission(
                request: PutResourcePermissionRequest
            ): IO[
              AwsError,
              zio.aws.ssmsap.model.PutResourcePermissionResponse.ReadOnly
            ] = proxy(PutResourcePermission, request)
            def updateApplicationSettings(
                request: UpdateApplicationSettingsRequest
            ): IO[
              AwsError,
              zio.aws.ssmsap.model.UpdateApplicationSettingsResponse.ReadOnly
            ] = proxy(UpdateApplicationSettings, request)
            def listOperations(
                request: ListOperationsRequest
            ): ZStream[Any, AwsError, zio.aws.ssmsap.model.Operation.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListOperations, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listOperationsPaginated(
                request: ListOperationsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListOperationsPaginated, request)
            def listComponents(request: ListComponentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssmsap.model.ComponentSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListComponents, request)
                }
                .getOrThrowFiberFailure()
            }
            def listComponentsPaginated(request: ListComponentsRequest): IO[
              AwsError,
              zio.aws.ssmsap.model.ListComponentsResponse.ReadOnly
            ] = proxy(ListComponentsPaginated, request)
            def startApplicationRefresh(
                request: StartApplicationRefreshRequest
            ): IO[
              AwsError,
              zio.aws.ssmsap.model.StartApplicationRefreshResponse.ReadOnly
            ] = proxy(StartApplicationRefresh, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.ssmsap.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def deleteResourcePermission(
                request: DeleteResourcePermissionRequest
            ): IO[
              AwsError,
              zio.aws.ssmsap.model.DeleteResourcePermissionResponse.ReadOnly
            ] = proxy(DeleteResourcePermission, request)
            def getResourcePermission(
                request: GetResourcePermissionRequest
            ): IO[
              AwsError,
              zio.aws.ssmsap.model.GetResourcePermissionResponse.ReadOnly
            ] = proxy(GetResourcePermission, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.ssmsap.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.ssmsap.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def listApplications(request: ListApplicationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssmsap.model.ApplicationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationsPaginated(request: ListApplicationsRequest): IO[
              AwsError,
              zio.aws.ssmsap.model.ListApplicationsResponse.ReadOnly
            ] = proxy(ListApplicationsPaginated, request)
            def getOperation(request: GetOperationRequest): IO[
              AwsError,
              zio.aws.ssmsap.model.GetOperationResponse.ReadOnly
            ] = proxy(GetOperation, request)
            def getDatabase(
                request: GetDatabaseRequest
            ): IO[AwsError, zio.aws.ssmsap.model.GetDatabaseResponse.ReadOnly] =
              proxy(GetDatabase, request)
            def getComponent(request: GetComponentRequest): IO[
              AwsError,
              zio.aws.ssmsap.model.GetComponentResponse.ReadOnly
            ] = proxy(GetComponent, request)
            def deregisterApplication(
                request: DeregisterApplicationRequest
            ): IO[
              AwsError,
              zio.aws.ssmsap.model.DeregisterApplicationResponse.ReadOnly
            ] = proxy(DeregisterApplication, request)
          }
        }
      }
    }
  }
}
