package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{
  SAPInstanceNumber,
  SID,
  InstanceId,
  TagValue,
  ApplicationId,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterApplicationRequest(
    applicationId: ApplicationId,
    applicationType: zio.aws.ssmsap.model.ApplicationType,
    instances: Iterable[InstanceId],
    sapInstanceNumber: Optional[SAPInstanceNumber] = Optional.Absent,
    sid: Optional[SID] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    credentials: Iterable[zio.aws.ssmsap.model.ApplicationCredential]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.RegisterApplicationRequest = {
    import RegisterApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.RegisterApplicationRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .applicationType(applicationType.unwrap)
      .instances(instances.map { item =>
        InstanceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        sapInstanceNumber.map(value =>
          SAPInstanceNumber.unwrap(value): java.lang.String
        )
      )(_.sapInstanceNumber)
      .optionallyWith(sid.map(value => SID.unwrap(value): java.lang.String))(
        _.sid
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .credentials(credentials.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.RegisterApplicationRequest.ReadOnly =
    zio.aws.ssmsap.model.RegisterApplicationRequest.wrap(buildAwsValue())
}
object RegisterApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.RegisterApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.RegisterApplicationRequest =
      zio.aws.ssmsap.model.RegisterApplicationRequest(
        applicationId,
        applicationType,
        instances,
        sapInstanceNumber.map(value => value),
        sid.map(value => value),
        tags.map(value => value),
        credentials.map { item =>
          item.asEditable
        }
      )
    def applicationId: ApplicationId
    def applicationType: zio.aws.ssmsap.model.ApplicationType
    def instances: List[InstanceId]
    def sapInstanceNumber: Optional[SAPInstanceNumber]
    def sid: Optional[SID]
    def tags: Optional[Map[TagKey, TagValue]]
    def credentials: List[zio.aws.ssmsap.model.ApplicationCredential.ReadOnly]
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getApplicationType
        : ZIO[Any, Nothing, zio.aws.ssmsap.model.ApplicationType] =
      ZIO.succeed(applicationType)
    def getInstances: ZIO[Any, Nothing, List[InstanceId]] =
      ZIO.succeed(instances)
    def getSapInstanceNumber: ZIO[Any, AwsError, SAPInstanceNumber] =
      AwsError.unwrapOptionField("sapInstanceNumber", sapInstanceNumber)
    def getSid: ZIO[Any, AwsError, SID] = AwsError.unwrapOptionField("sid", sid)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCredentials: ZIO[Any, Nothing, List[
      zio.aws.ssmsap.model.ApplicationCredential.ReadOnly
    ]] = ZIO.succeed(credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.RegisterApplicationRequest
  ) extends zio.aws.ssmsap.model.RegisterApplicationRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.ssmsap.model.primitives.ApplicationId(impl.applicationId())
    override val applicationType: zio.aws.ssmsap.model.ApplicationType =
      zio.aws.ssmsap.model.ApplicationType.wrap(impl.applicationType())
    override val instances: List[InstanceId] = impl
      .instances()
      .asScala
      .map { item =>
        zio.aws.ssmsap.model.primitives.InstanceId(item)
      }
      .toList
    override val sapInstanceNumber: Optional[SAPInstanceNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sapInstanceNumber())
        .map(value => zio.aws.ssmsap.model.primitives.SAPInstanceNumber(value))
    override val sid: Optional[SID] = zio.aws.core.internal
      .optionalFromNullable(impl.sid())
      .map(value => zio.aws.ssmsap.model.primitives.SID(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssmsap.model.primitives
              .TagKey(key) -> zio.aws.ssmsap.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val credentials
        : List[zio.aws.ssmsap.model.ApplicationCredential.ReadOnly] = impl
      .credentials()
      .asScala
      .map { item =>
        zio.aws.ssmsap.model.ApplicationCredential.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.RegisterApplicationRequest
  ): zio.aws.ssmsap.model.RegisterApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
