package zio.aws.ssmsap
import zio.aws.ssmsap.model.primitives.{
  DatabaseId,
  OperationId,
  InstanceId,
  TagValue,
  ComponentId,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.ssmsap.model.primitives.TagValue.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AppRegistryArn extends Subtype[String]
    type AppRegistryArn = zio.aws.ssmsap.model.primitives.AppRegistryArn.Type
    object ApplicationId extends Subtype[String]
    type ApplicationId = zio.aws.ssmsap.model.primitives.ApplicationId.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.ssmsap.model.primitives.Arn.Type
    object ComponentId extends Subtype[String]
    type ComponentId = zio.aws.ssmsap.model.primitives.ComponentId.Type
    object DatabaseId extends Subtype[String]
    type DatabaseId = zio.aws.ssmsap.model.primitives.DatabaseId.Type
    object DatabaseName extends Subtype[String]
    type DatabaseName = zio.aws.ssmsap.model.primitives.DatabaseName.Type
    object InstanceId extends Subtype[String]
    type InstanceId = zio.aws.ssmsap.model.primitives.InstanceId.Type
    type Integer = Int
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.ssmsap.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.ssmsap.model.primitives.NextToken.Type
    object OperationId extends Subtype[String]
    type OperationId = zio.aws.ssmsap.model.primitives.OperationId.Type
    object OperationType extends Subtype[String]
    type OperationType = zio.aws.ssmsap.model.primitives.OperationType.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.ssmsap.model.primitives.ResourceId.Type
    object ResourceType extends Subtype[String]
    type ResourceType = zio.aws.ssmsap.model.primitives.ResourceType.Type
    object SAPInstanceNumber extends Subtype[String]
    type SAPInstanceNumber =
      zio.aws.ssmsap.model.primitives.SAPInstanceNumber.Type
    object SID extends Subtype[String]
    type SID = zio.aws.ssmsap.model.primitives.SID.Type
    object SecretId extends Subtype[String]
    type SecretId = zio.aws.ssmsap.model.primitives.SecretId.Type
    object SsmSapArn extends Subtype[String]
    type SsmSapArn = zio.aws.ssmsap.model.primitives.SsmSapArn.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.ssmsap.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.ssmsap.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.ssmsap.model.primitives.Timestamp.Type
  }
  type ApplicationCredentialList =
    List[zio.aws.ssmsap.model.ApplicationCredential]
  type ApplicationSummaryList = List[zio.aws.ssmsap.model.ApplicationSummary]
  type ComponentIdList = List[ComponentId]
  type ComponentSummaryList = List[zio.aws.ssmsap.model.ComponentSummary]
  type DatabaseIdList = List[DatabaseId]
  type DatabaseSummaryList = List[zio.aws.ssmsap.model.DatabaseSummary]
  type HostList = List[zio.aws.ssmsap.model.Host]
  type InstanceList = List[InstanceId]
  type OperationIdList = List[OperationId]
  type OperationProperties = Map[String, String]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
