package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.OperationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterApplicationResponse(
    application: Optional[zio.aws.ssmsap.model.Application] = Optional.Absent,
    operationId: Optional[OperationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.RegisterApplicationResponse = {
    import RegisterApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.RegisterApplicationResponse
      .builder()
      .optionallyWith(application.map(value => value.buildAwsValue()))(
        _.application
      )
      .optionallyWith(
        operationId.map(value => OperationId.unwrap(value): java.lang.String)
      )(_.operationId)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.RegisterApplicationResponse.ReadOnly =
    zio.aws.ssmsap.model.RegisterApplicationResponse.wrap(buildAwsValue())
}
object RegisterApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.RegisterApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.RegisterApplicationResponse =
      zio.aws.ssmsap.model.RegisterApplicationResponse(
        application.map(value => value.asEditable),
        operationId.map(value => value)
      )
    def application: Optional[zio.aws.ssmsap.model.Application.ReadOnly]
    def operationId: Optional[OperationId]
    def getApplication
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.Application.ReadOnly] =
      AwsError.unwrapOptionField("application", application)
    def getOperationId: ZIO[Any, AwsError, OperationId] =
      AwsError.unwrapOptionField("operationId", operationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.RegisterApplicationResponse
  ) extends zio.aws.ssmsap.model.RegisterApplicationResponse.ReadOnly {
    override val application
        : Optional[zio.aws.ssmsap.model.Application.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.application())
        .map(value => zio.aws.ssmsap.model.Application.wrap(value))
    override val operationId: Optional[OperationId] = zio.aws.core.internal
      .optionalFromNullable(impl.operationId())
      .map(value => zio.aws.ssmsap.model.primitives.OperationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.RegisterApplicationResponse
  ): zio.aws.ssmsap.model.RegisterApplicationResponse.ReadOnly = new Wrapper(
    impl
  )
}
