package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDatabaseResponse(
    database: Optional[zio.aws.ssmsap.model.Database] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.GetDatabaseResponse = {
    import GetDatabaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.GetDatabaseResponse
      .builder()
      .optionallyWith(database.map(value => value.buildAwsValue()))(_.database)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.GetDatabaseResponse.ReadOnly =
    zio.aws.ssmsap.model.GetDatabaseResponse.wrap(buildAwsValue())
}
object GetDatabaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.GetDatabaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.GetDatabaseResponse =
      zio.aws.ssmsap.model.GetDatabaseResponse(
        database.map(value => value.asEditable),
        tags.map(value => value)
      )
    def database: Optional[zio.aws.ssmsap.model.Database.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getDatabase
        : ZIO[Any, AwsError, zio.aws.ssmsap.model.Database.ReadOnly] =
      AwsError.unwrapOptionField("database", database)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.GetDatabaseResponse
  ) extends zio.aws.ssmsap.model.GetDatabaseResponse.ReadOnly {
    override val database: Optional[zio.aws.ssmsap.model.Database.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.database())
        .map(value => zio.aws.ssmsap.model.Database.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssmsap.model.primitives
              .TagKey(key) -> zio.aws.ssmsap.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.GetDatabaseResponse
  ): zio.aws.ssmsap.model.GetDatabaseResponse.ReadOnly = new Wrapper(impl)
}
