package zio.aws.ssmsap
import software.amazon.awssdk.services.ssmsap.model.{
  DeleteResourcePermissionResponse,
  RegisterApplicationRequest,
  GetOperationRequest,
  GetDatabaseResponse,
  ListDatabasesResponse,
  ListTagsForResourceRequest,
  GetDatabaseRequest,
  DeregisterApplicationResponse,
  GetComponentResponse,
  ComponentSummary,
  ListDatabasesRequest,
  UpdateApplicationSettingsRequest,
  DatabaseSummary,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  Operation,
  ListApplicationsResponse,
  GetOperationResponse,
  ListOperationsResponse,
  GetApplicationRequest,
  UpdateApplicationSettingsResponse,
  PutResourcePermissionRequest,
  GetResourcePermissionResponse,
  GetResourcePermissionRequest,
  UntagResourceRequest,
  ListApplicationsRequest,
  ListComponentsRequest,
  DeleteResourcePermissionRequest,
  DeregisterApplicationRequest,
  ListComponentsResponse,
  GetComponentRequest,
  RegisterApplicationResponse,
  PutResourcePermissionResponse,
  TagResourceResponse,
  ApplicationSummary,
  GetApplicationResponse,
  ListOperationsRequest,
  TagResourceRequest
}
import zio.aws.ssmsap.model.ListOperationsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.ssmsap.{
  SsmSapAsyncClientBuilder,
  SsmSapAsyncClient
}
import scala.jdk.CollectionConverters._
trait SsmSap extends AspectSupport[SsmSap] {
  val api: SsmSapAsyncClient
  def listDatabases(
      request: zio.aws.ssmsap.model.ListDatabasesRequest
  ): ZStream[Any, AwsError, zio.aws.ssmsap.model.DatabaseSummary.ReadOnly]
  def listDatabasesPaginated(
      request: zio.aws.ssmsap.model.ListDatabasesRequest
  ): IO[AwsError, zio.aws.ssmsap.model.ListDatabasesResponse.ReadOnly]
  def getApplication(
      request: zio.aws.ssmsap.model.GetApplicationRequest
  ): IO[AwsError, zio.aws.ssmsap.model.GetApplicationResponse.ReadOnly]
  def registerApplication(
      request: zio.aws.ssmsap.model.RegisterApplicationRequest
  ): IO[AwsError, zio.aws.ssmsap.model.RegisterApplicationResponse.ReadOnly]
  def putResourcePermission(
      request: zio.aws.ssmsap.model.PutResourcePermissionRequest
  ): IO[AwsError, zio.aws.ssmsap.model.PutResourcePermissionResponse.ReadOnly]
  def updateApplicationSettings(
      request: zio.aws.ssmsap.model.UpdateApplicationSettingsRequest
  ): IO[
    AwsError,
    zio.aws.ssmsap.model.UpdateApplicationSettingsResponse.ReadOnly
  ]
  def listOperations(
      request: zio.aws.ssmsap.model.ListOperationsRequest
  ): ZStream[Any, AwsError, zio.aws.ssmsap.model.Operation.ReadOnly]
  def listOperationsPaginated(
      request: zio.aws.ssmsap.model.ListOperationsRequest
  ): IO[AwsError, ReadOnly]
  def listComponents(
      request: zio.aws.ssmsap.model.ListComponentsRequest
  ): ZStream[Any, AwsError, zio.aws.ssmsap.model.ComponentSummary.ReadOnly]
  def listComponentsPaginated(
      request: zio.aws.ssmsap.model.ListComponentsRequest
  ): IO[AwsError, zio.aws.ssmsap.model.ListComponentsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.ssmsap.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.ssmsap.model.UntagResourceResponse.ReadOnly]
  def deleteResourcePermission(
      request: zio.aws.ssmsap.model.DeleteResourcePermissionRequest
  ): IO[
    AwsError,
    zio.aws.ssmsap.model.DeleteResourcePermissionResponse.ReadOnly
  ]
  def getResourcePermission(
      request: zio.aws.ssmsap.model.GetResourcePermissionRequest
  ): IO[AwsError, zio.aws.ssmsap.model.GetResourcePermissionResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.ssmsap.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.ssmsap.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.ssmsap.model.TagResourceRequest
  ): IO[AwsError, zio.aws.ssmsap.model.TagResourceResponse.ReadOnly]
  def listApplications(
      request: zio.aws.ssmsap.model.ListApplicationsRequest
  ): ZStream[Any, AwsError, zio.aws.ssmsap.model.ApplicationSummary.ReadOnly]
  def listApplicationsPaginated(
      request: zio.aws.ssmsap.model.ListApplicationsRequest
  ): IO[AwsError, zio.aws.ssmsap.model.ListApplicationsResponse.ReadOnly]
  def getOperation(
      request: zio.aws.ssmsap.model.GetOperationRequest
  ): IO[AwsError, zio.aws.ssmsap.model.GetOperationResponse.ReadOnly]
  def getDatabase(
      request: zio.aws.ssmsap.model.GetDatabaseRequest
  ): IO[AwsError, zio.aws.ssmsap.model.GetDatabaseResponse.ReadOnly]
  def getComponent(
      request: zio.aws.ssmsap.model.GetComponentRequest
  ): IO[AwsError, zio.aws.ssmsap.model.GetComponentResponse.ReadOnly]
  def deregisterApplication(
      request: zio.aws.ssmsap.model.DeregisterApplicationRequest
  ): IO[AwsError, zio.aws.ssmsap.model.DeregisterApplicationResponse.ReadOnly]
}
object SsmSap {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SsmSap] = customized(
    identity
  )
  def customized(
      customization: SsmSapAsyncClientBuilder => SsmSapAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SsmSap] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SsmSapAsyncClientBuilder => SsmSapAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, SsmSap] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SsmSapAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[SsmSapAsyncClient, SsmSapAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[SsmSapAsyncClient, SsmSapAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new SsmSapImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SsmSapImpl[R](
      override val api: SsmSapAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SsmSap
      with AwsServiceBase[R] {
    override val serviceName: String = "SsmSap"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SsmSapImpl[R1] = new SsmSapImpl(api, newAspect, r)
    def listDatabases(
        request: zio.aws.ssmsap.model.ListDatabasesRequest
    ): ZStream[Any, AwsError, zio.aws.ssmsap.model.DatabaseSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListDatabasesRequest,
        ListDatabasesResponse,
        DatabaseSummary
      ](
        "listDatabases",
        api.listDatabases,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.databases().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssmsap.model.DatabaseSummary.wrap(item))
        .provideEnvironment(r)
    def listDatabasesPaginated(
        request: zio.aws.ssmsap.model.ListDatabasesRequest
    ): IO[AwsError, zio.aws.ssmsap.model.ListDatabasesResponse.ReadOnly] =
      asyncRequestResponse[ListDatabasesRequest, ListDatabasesResponse](
        "listDatabases",
        api.listDatabases
      )(request.buildAwsValue())
        .map(zio.aws.ssmsap.model.ListDatabasesResponse.wrap)
        .provideEnvironment(r)
    def getApplication(
        request: zio.aws.ssmsap.model.GetApplicationRequest
    ): IO[AwsError, zio.aws.ssmsap.model.GetApplicationResponse.ReadOnly] =
      asyncRequestResponse[GetApplicationRequest, GetApplicationResponse](
        "getApplication",
        api.getApplication
      )(request.buildAwsValue())
        .map(zio.aws.ssmsap.model.GetApplicationResponse.wrap)
        .provideEnvironment(r)
    def registerApplication(
        request: zio.aws.ssmsap.model.RegisterApplicationRequest
    ): IO[AwsError, zio.aws.ssmsap.model.RegisterApplicationResponse.ReadOnly] =
      asyncRequestResponse[
        RegisterApplicationRequest,
        RegisterApplicationResponse
      ]("registerApplication", api.registerApplication)(request.buildAwsValue())
        .map(zio.aws.ssmsap.model.RegisterApplicationResponse.wrap)
        .provideEnvironment(r)
    def putResourcePermission(
        request: zio.aws.ssmsap.model.PutResourcePermissionRequest
    ): IO[
      AwsError,
      zio.aws.ssmsap.model.PutResourcePermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      PutResourcePermissionRequest,
      PutResourcePermissionResponse
    ]("putResourcePermission", api.putResourcePermission)(
      request.buildAwsValue()
    ).map(zio.aws.ssmsap.model.PutResourcePermissionResponse.wrap)
      .provideEnvironment(r)
    def updateApplicationSettings(
        request: zio.aws.ssmsap.model.UpdateApplicationSettingsRequest
    ): IO[
      AwsError,
      zio.aws.ssmsap.model.UpdateApplicationSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateApplicationSettingsRequest,
      UpdateApplicationSettingsResponse
    ]("updateApplicationSettings", api.updateApplicationSettings)(
      request.buildAwsValue()
    ).map(zio.aws.ssmsap.model.UpdateApplicationSettingsResponse.wrap)
      .provideEnvironment(r)
    def listOperations(
        request: zio.aws.ssmsap.model.ListOperationsRequest
    ): ZStream[Any, AwsError, zio.aws.ssmsap.model.Operation.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListOperationsRequest,
        ListOperationsResponse,
        Operation
      ](
        "listOperations",
        api.listOperations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.operations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssmsap.model.Operation.wrap(item))
        .provideEnvironment(r)
    def listOperationsPaginated(
        request: zio.aws.ssmsap.model.ListOperationsRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[ListOperationsRequest, ListOperationsResponse](
        "listOperations",
        api.listOperations
      )(request.buildAwsValue())
        .map(zio.aws.ssmsap.model.ListOperationsResponse.wrap)
        .provideEnvironment(r)
    def listComponents(
        request: zio.aws.ssmsap.model.ListComponentsRequest
    ): ZStream[Any, AwsError, zio.aws.ssmsap.model.ComponentSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListComponentsRequest,
        ListComponentsResponse,
        ComponentSummary
      ](
        "listComponents",
        api.listComponents,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.components().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ssmsap.model.ComponentSummary.wrap(item))
        .provideEnvironment(r)
    def listComponentsPaginated(
        request: zio.aws.ssmsap.model.ListComponentsRequest
    ): IO[AwsError, zio.aws.ssmsap.model.ListComponentsResponse.ReadOnly] =
      asyncRequestResponse[ListComponentsRequest, ListComponentsResponse](
        "listComponents",
        api.listComponents
      )(request.buildAwsValue())
        .map(zio.aws.ssmsap.model.ListComponentsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.ssmsap.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.ssmsap.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.ssmsap.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteResourcePermission(
        request: zio.aws.ssmsap.model.DeleteResourcePermissionRequest
    ): IO[
      AwsError,
      zio.aws.ssmsap.model.DeleteResourcePermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteResourcePermissionRequest,
      DeleteResourcePermissionResponse
    ]("deleteResourcePermission", api.deleteResourcePermission)(
      request.buildAwsValue()
    ).map(zio.aws.ssmsap.model.DeleteResourcePermissionResponse.wrap)
      .provideEnvironment(r)
    def getResourcePermission(
        request: zio.aws.ssmsap.model.GetResourcePermissionRequest
    ): IO[
      AwsError,
      zio.aws.ssmsap.model.GetResourcePermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetResourcePermissionRequest,
      GetResourcePermissionResponse
    ]("getResourcePermission", api.getResourcePermission)(
      request.buildAwsValue()
    ).map(zio.aws.ssmsap.model.GetResourcePermissionResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.ssmsap.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.ssmsap.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.ssmsap.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.ssmsap.model.TagResourceRequest
    ): IO[AwsError, zio.aws.ssmsap.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.ssmsap.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listApplications(
        request: zio.aws.ssmsap.model.ListApplicationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssmsap.model.ApplicationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListApplicationsRequest,
      ListApplicationsResponse,
      ApplicationSummary
    ](
      "listApplications",
      api.listApplications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applications().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssmsap.model.ApplicationSummary.wrap(item))
      .provideEnvironment(r)
    def listApplicationsPaginated(
        request: zio.aws.ssmsap.model.ListApplicationsRequest
    ): IO[AwsError, zio.aws.ssmsap.model.ListApplicationsResponse.ReadOnly] =
      asyncRequestResponse[ListApplicationsRequest, ListApplicationsResponse](
        "listApplications",
        api.listApplications
      )(request.buildAwsValue())
        .map(zio.aws.ssmsap.model.ListApplicationsResponse.wrap)
        .provideEnvironment(r)
    def getOperation(
        request: zio.aws.ssmsap.model.GetOperationRequest
    ): IO[AwsError, zio.aws.ssmsap.model.GetOperationResponse.ReadOnly] =
      asyncRequestResponse[GetOperationRequest, GetOperationResponse](
        "getOperation",
        api.getOperation
      )(request.buildAwsValue())
        .map(zio.aws.ssmsap.model.GetOperationResponse.wrap)
        .provideEnvironment(r)
    def getDatabase(
        request: zio.aws.ssmsap.model.GetDatabaseRequest
    ): IO[AwsError, zio.aws.ssmsap.model.GetDatabaseResponse.ReadOnly] =
      asyncRequestResponse[GetDatabaseRequest, GetDatabaseResponse](
        "getDatabase",
        api.getDatabase
      )(request.buildAwsValue())
        .map(zio.aws.ssmsap.model.GetDatabaseResponse.wrap)
        .provideEnvironment(r)
    def getComponent(
        request: zio.aws.ssmsap.model.GetComponentRequest
    ): IO[AwsError, zio.aws.ssmsap.model.GetComponentResponse.ReadOnly] =
      asyncRequestResponse[GetComponentRequest, GetComponentResponse](
        "getComponent",
        api.getComponent
      )(request.buildAwsValue())
        .map(zio.aws.ssmsap.model.GetComponentResponse.wrap)
        .provideEnvironment(r)
    def deregisterApplication(
        request: zio.aws.ssmsap.model.DeregisterApplicationRequest
    ): IO[
      AwsError,
      zio.aws.ssmsap.model.DeregisterApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterApplicationRequest,
      DeregisterApplicationResponse
    ]("deregisterApplication", api.deregisterApplication)(
      request.buildAwsValue()
    ).map(zio.aws.ssmsap.model.DeregisterApplicationResponse.wrap)
      .provideEnvironment(r)
  }
  def listDatabases(
      request: zio.aws.ssmsap.model.ListDatabasesRequest
  ): ZStream[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.DatabaseSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatabases(request))
  def listDatabasesPaginated(
      request: zio.aws.ssmsap.model.ListDatabasesRequest
  ): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.ListDatabasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatabasesPaginated(request))
  def getApplication(request: zio.aws.ssmsap.model.GetApplicationRequest): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.GetApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplication(request))
  def registerApplication(
      request: zio.aws.ssmsap.model.RegisterApplicationRequest
  ): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.RegisterApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerApplication(request))
  def putResourcePermission(
      request: zio.aws.ssmsap.model.PutResourcePermissionRequest
  ): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.PutResourcePermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourcePermission(request))
  def updateApplicationSettings(
      request: zio.aws.ssmsap.model.UpdateApplicationSettingsRequest
  ): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.UpdateApplicationSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplicationSettings(request))
  def listOperations(
      request: zio.aws.ssmsap.model.ListOperationsRequest
  ): ZStream[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.Operation.ReadOnly
  ] = ZStream.serviceWithStream(_.listOperations(request))
  def listOperationsPaginated(
      request: zio.aws.ssmsap.model.ListOperationsRequest
  ): ZIO[zio.aws.ssmsap.SsmSap, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listOperationsPaginated(request))
  def listComponents(
      request: zio.aws.ssmsap.model.ListComponentsRequest
  ): ZStream[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.ComponentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listComponents(request))
  def listComponentsPaginated(
      request: zio.aws.ssmsap.model.ListComponentsRequest
  ): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.ListComponentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComponentsPaginated(request))
  def untagResource(request: zio.aws.ssmsap.model.UntagResourceRequest): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteResourcePermission(
      request: zio.aws.ssmsap.model.DeleteResourcePermissionRequest
  ): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.DeleteResourcePermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourcePermission(request))
  def getResourcePermission(
      request: zio.aws.ssmsap.model.GetResourcePermissionRequest
  ): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.GetResourcePermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourcePermission(request))
  def listTagsForResource(
      request: zio.aws.ssmsap.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.ssmsap.model.TagResourceRequest): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listApplications(
      request: zio.aws.ssmsap.model.ListApplicationsRequest
  ): ZStream[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.ApplicationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplications(request))
  def listApplicationsPaginated(
      request: zio.aws.ssmsap.model.ListApplicationsRequest
  ): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.ListApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationsPaginated(request))
  def getOperation(request: zio.aws.ssmsap.model.GetOperationRequest): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.GetOperationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOperation(request))
  def getDatabase(request: zio.aws.ssmsap.model.GetDatabaseRequest): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.GetDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDatabase(request))
  def getComponent(request: zio.aws.ssmsap.model.GetComponentRequest): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.GetComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComponent(request))
  def deregisterApplication(
      request: zio.aws.ssmsap.model.DeregisterApplicationRequest
  ): ZIO[
    zio.aws.ssmsap.SsmSap,
    AwsError,
    zio.aws.ssmsap.model.DeregisterApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterApplication(request))
}
