package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{ActivationCode, ActivationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateActivationResponse(
    activationId: Optional[ActivationId] = Optional.Absent,
    activationCode: Optional[ActivationCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateActivationResponse = {
    import CreateActivationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateActivationResponse
      .builder()
      .optionallyWith(
        activationId.map(value => ActivationId.unwrap(value): java.lang.String)
      )(_.activationId)
      .optionallyWith(
        activationCode.map(value =>
          ActivationCode.unwrap(value): java.lang.String
        )
      )(_.activationCode)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateActivationResponse.ReadOnly =
    zio.aws.ssm.model.CreateActivationResponse.wrap(buildAwsValue())
}
object CreateActivationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateActivationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateActivationResponse =
      zio.aws.ssm.model.CreateActivationResponse(
        activationId.map(value => value),
        activationCode.map(value => value)
      )
    def activationId: Optional[ActivationId]
    def activationCode: Optional[ActivationCode]
    def getActivationId: ZIO[Any, AwsError, ActivationId] =
      AwsError.unwrapOptionField("activationId", activationId)
    def getActivationCode: ZIO[Any, AwsError, ActivationCode] =
      AwsError.unwrapOptionField("activationCode", activationCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateActivationResponse
  ) extends zio.aws.ssm.model.CreateActivationResponse.ReadOnly {
    override val activationId: Optional[ActivationId] = zio.aws.core.internal
      .optionalFromNullable(impl.activationId())
      .map(value => zio.aws.ssm.model.primitives.ActivationId(value))
    override val activationCode: Optional[ActivationCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activationCode())
        .map(value => zio.aws.ssm.model.primitives.ActivationCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateActivationResponse
  ): zio.aws.ssm.model.CreateActivationResponse.ReadOnly = new Wrapper(impl)
}
