package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait CalendarState {
  def unwrap: software.amazon.awssdk.services.ssm.model.CalendarState
}
object CalendarState {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.CalendarState
  ): zio.aws.ssm.model.CalendarState = value match {
    case software.amazon.awssdk.services.ssm.model.CalendarState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.CalendarState.OPEN =>
      val r = OPEN
      r
    case software.amazon.awssdk.services.ssm.model.CalendarState.CLOSED =>
      val r = CLOSED
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.CalendarState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CalendarState =
      software.amazon.awssdk.services.ssm.model.CalendarState.UNKNOWN_TO_SDK_VERSION
  }
  case object OPEN extends zio.aws.ssm.model.CalendarState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CalendarState =
      software.amazon.awssdk.services.ssm.model.CalendarState.OPEN
  }
  case object CLOSED extends zio.aws.ssm.model.CalendarState {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.CalendarState =
      software.amazon.awssdk.services.ssm.model.CalendarState.CLOSED
  }
}
