package zio.aws.ssm
import zio.aws.ssm.model.DescribeAutomationExecutionsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.ssm.SsmAsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.ssm.model.primitives.{AttributeValue, AttributeName, MetadataKey}
import zio.aws.ssm.model.{
  GetMaintenanceWindowRequest,
  GetServiceSettingRequest,
  LabelParameterVersionRequest,
  ListDocumentVersionsRequest,
  DescribeMaintenanceWindowTasksRequest,
  DescribePatchGroupStateRequest,
  DescribeInstancePatchStatesRequest,
  DescribeMaintenanceWindowsForTargetRequest,
  AssociateOpsItemRelatedItemRequest,
  GetResourcePoliciesRequest,
  StopAutomationExecutionRequest,
  GetMaintenanceWindowExecutionRequest,
  GetDefaultPatchBaselineRequest,
  DescribePatchGroupsRequest,
  CancelMaintenanceWindowExecutionRequest,
  DescribeEffectivePatchesForPatchBaselineRequest,
  RegisterTaskWithMaintenanceWindowRequest,
  ModifyDocumentPermissionRequest,
  DeregisterTaskFromMaintenanceWindowRequest,
  GetDeployablePatchSnapshotForInstanceRequest,
  ListOpsMetadataRequest,
  GetAutomationExecutionRequest,
  DisassociateOpsItemRelatedItemRequest,
  DeregisterTargetFromMaintenanceWindowRequest,
  DescribeAssociationExecutionsRequest,
  UpdateDocumentDefaultVersionRequest,
  DeleteResourceDataSyncRequest,
  CreatePatchBaselineRequest,
  AddTagsToResourceRequest,
  CreateAssociationBatchRequest,
  ListComplianceSummariesRequest,
  UnlabelParameterVersionRequest,
  DescribeActivationsRequest,
  RegisterDefaultPatchBaselineRequest,
  DescribeMaintenanceWindowsRequest,
  ListAssociationVersionsRequest,
  DeleteOpsMetadataRequest,
  ListOpsItemRelatedItemsRequest,
  ResumeSessionRequest,
  PutResourcePolicyRequest,
  GetOpsSummaryRequest,
  DeleteActivationRequest,
  UpdateAssociationStatusRequest,
  SendAutomationSignalRequest,
  DeleteOpsItemRequest,
  DescribeDocumentPermissionRequest,
  ListTagsForResourceRequest,
  ListCommandsRequest,
  DescribeInstanceInformationRequest,
  UpdateResourceDataSyncRequest,
  DescribeMaintenanceWindowScheduleRequest,
  DescribeAvailablePatchesRequest,
  DeleteParameterRequest,
  GetParameterHistoryRequest,
  DeleteMaintenanceWindowRequest,
  UpdateDocumentRequest,
  DeletePatchBaselineRequest,
  DescribeSessionsRequest,
  GetParametersByPathRequest,
  GetParameterRequest,
  GetPatchBaselineRequest,
  DescribeAutomationStepExecutionsRequest,
  DescribeEffectiveInstanceAssociationsRequest,
  DescribeInventoryDeletionsRequest,
  UpdateMaintenanceWindowTaskRequest,
  DescribeOpsItemsRequest,
  UpdateManagedInstanceRoleRequest,
  GetMaintenanceWindowTaskRequest,
  PutParameterRequest,
  UpdateServiceSettingRequest,
  TerminateSessionRequest,
  DescribeAssociationRequest,
  CreateOpsMetadataRequest,
  DeregisterPatchBaselineForPatchGroupRequest,
  DescribeAutomationExecutionsRequest,
  CancelCommandRequest,
  StartSessionRequest,
  DeleteAssociationRequest,
  RemoveTagsFromResourceRequest,
  ListDocumentMetadataHistoryRequest,
  GetOpsItemRequest,
  DescribeMaintenanceWindowTargetsRequest,
  UpdateOpsMetadataRequest,
  DeleteParametersRequest,
  DeregisterManagedInstanceRequest,
  DescribePatchBaselinesRequest,
  RegisterTargetWithMaintenanceWindowRequest,
  PutInventoryRequest,
  RegisterPatchBaselineForPatchGroupRequest,
  DeleteDocumentRequest,
  GetParametersRequest,
  GetCommandInvocationRequest,
  DeleteResourcePolicyRequest,
  GetMaintenanceWindowExecutionTaskInvocationRequest,
  ListResourceDataSyncRequest,
  UpdateDocumentMetadataRequest,
  ListDocumentsRequest,
  DescribeMaintenanceWindowExecutionsRequest,
  GetCalendarStateRequest,
  ListOpsItemEventsRequest,
  UpdateAssociationRequest,
  DescribeInstanceAssociationsStatusRequest,
  StartAutomationExecutionRequest,
  DescribeAssociationExecutionTargetsRequest,
  StartAssociationsOnceRequest,
  ListAssociationsRequest,
  ListInventoryEntriesRequest,
  ListComplianceItemsRequest,
  GetDocumentRequest,
  DescribeInstancePatchesRequest,
  CreateMaintenanceWindowRequest,
  CreateActivationRequest,
  ResetServiceSettingRequest,
  UpdateMaintenanceWindowTargetRequest,
  GetInventoryRequest,
  SendCommandRequest,
  DescribeMaintenanceWindowExecutionTaskInvocationsRequest,
  PutComplianceItemsRequest,
  UpdatePatchBaselineRequest,
  ListResourceComplianceSummariesRequest,
  ListCommandInvocationsRequest,
  GetPatchBaselineForPatchGroupRequest,
  DescribeDocumentRequest,
  CreateOpsItemRequest,
  CreateResourceDataSyncRequest,
  GetOpsMetadataRequest,
  DescribePatchPropertiesRequest,
  DescribeParametersRequest,
  GetMaintenanceWindowExecutionTaskRequest,
  DescribeInstancePatchStatesForPatchGroupRequest,
  CreateDocumentRequest,
  UpdateMaintenanceWindowRequest,
  StartChangeRequestExecutionRequest,
  GetConnectionStatusRequest,
  GetInventorySchemaRequest,
  UpdateOpsItemRequest,
  CreateAssociationRequest,
  DescribeMaintenanceWindowExecutionTasksRequest,
  DeleteInventoryRequest
}
object SsmMock extends Mock[Ssm] {
  object DeleteInventory
      extends Effect[
        DeleteInventoryRequest,
        AwsError,
        zio.aws.ssm.model.DeleteInventoryResponse.ReadOnly
      ]
  object DescribeAutomationStepExecutions
      extends Stream[
        DescribeAutomationStepExecutionsRequest,
        AwsError,
        zio.aws.ssm.model.StepExecution.ReadOnly
      ]
  object DescribeAutomationStepExecutionsPaginated
      extends Effect[
        DescribeAutomationStepExecutionsRequest,
        AwsError,
        zio.aws.ssm.model.DescribeAutomationStepExecutionsResponse.ReadOnly
      ]
  object DeleteParameters
      extends Effect[
        DeleteParametersRequest,
        AwsError,
        zio.aws.ssm.model.DeleteParametersResponse.ReadOnly
      ]
  object GetParameterHistory
      extends Stream[
        GetParameterHistoryRequest,
        AwsError,
        zio.aws.ssm.model.ParameterHistory.ReadOnly
      ]
  object GetParameterHistoryPaginated
      extends Effect[
        GetParameterHistoryRequest,
        AwsError,
        zio.aws.ssm.model.GetParameterHistoryResponse.ReadOnly
      ]
  object AddTagsToResource
      extends Effect[
        AddTagsToResourceRequest,
        AwsError,
        zio.aws.ssm.model.AddTagsToResourceResponse.ReadOnly
      ]
  object DescribeSessions
      extends Stream[
        DescribeSessionsRequest,
        AwsError,
        zio.aws.ssm.model.Session.ReadOnly
      ]
  object DescribeSessionsPaginated
      extends Effect[
        DescribeSessionsRequest,
        AwsError,
        zio.aws.ssm.model.DescribeSessionsResponse.ReadOnly
      ]
  object ListResourceDataSync
      extends Stream[
        ListResourceDataSyncRequest,
        AwsError,
        zio.aws.ssm.model.ResourceDataSyncItem.ReadOnly
      ]
  object ListResourceDataSyncPaginated
      extends Effect[
        ListResourceDataSyncRequest,
        AwsError,
        zio.aws.ssm.model.ListResourceDataSyncResponse.ReadOnly
      ]
  object GetOpsMetadata
      extends Effect[GetOpsMetadataRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly,
        Tuple2[MetadataKey, zio.aws.ssm.model.MetadataValue.ReadOnly]
      ]]
  object GetOpsMetadataPaginated
      extends Effect[
        GetOpsMetadataRequest,
        AwsError,
        zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly
      ]
  object DeregisterPatchBaselineForPatchGroup
      extends Effect[
        DeregisterPatchBaselineForPatchGroupRequest,
        AwsError,
        zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupResponse.ReadOnly
      ]
  object StopAutomationExecution
      extends Effect[
        StopAutomationExecutionRequest,
        AwsError,
        zio.aws.ssm.model.StopAutomationExecutionResponse.ReadOnly
      ]
  object DescribeInstanceAssociationsStatus
      extends Stream[
        DescribeInstanceAssociationsStatusRequest,
        AwsError,
        zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly
      ]
  object DescribeInstanceAssociationsStatusPaginated
      extends Effect[
        DescribeInstanceAssociationsStatusRequest,
        AwsError,
        zio.aws.ssm.model.DescribeInstanceAssociationsStatusResponse.ReadOnly
      ]
  object DescribeMaintenanceWindowsForTarget
      extends Stream[
        DescribeMaintenanceWindowsForTargetRequest,
        AwsError,
        zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.ReadOnly
      ]
  object DescribeMaintenanceWindowsForTargetPaginated
      extends Effect[
        DescribeMaintenanceWindowsForTargetRequest,
        AwsError,
        zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetResponse.ReadOnly
      ]
  object GetParameters
      extends Effect[
        GetParametersRequest,
        AwsError,
        zio.aws.ssm.model.GetParametersResponse.ReadOnly
      ]
  object DescribeInstancePatchStates
      extends Stream[
        DescribeInstancePatchStatesRequest,
        AwsError,
        zio.aws.ssm.model.InstancePatchState.ReadOnly
      ]
  object DescribeInstancePatchStatesPaginated
      extends Effect[
        DescribeInstancePatchStatesRequest,
        AwsError,
        zio.aws.ssm.model.DescribeInstancePatchStatesResponse.ReadOnly
      ]
  object ListInventoryEntries
      extends Effect[
        ListInventoryEntriesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly,
          Map[AttributeName, AttributeValue]
        ]
      ]
  object ListInventoryEntriesPaginated
      extends Effect[
        ListInventoryEntriesRequest,
        AwsError,
        zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly
      ]
  object DescribeMaintenanceWindowExecutions
      extends Stream[
        DescribeMaintenanceWindowExecutionsRequest,
        AwsError,
        zio.aws.ssm.model.MaintenanceWindowExecution.ReadOnly
      ]
  object DescribeMaintenanceWindowExecutionsPaginated
      extends Effect[
        DescribeMaintenanceWindowExecutionsRequest,
        AwsError,
        zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsResponse.ReadOnly
      ]
  object DescribeAssociationExecutions
      extends Stream[
        DescribeAssociationExecutionsRequest,
        AwsError,
        zio.aws.ssm.model.AssociationExecution.ReadOnly
      ]
  object DescribeAssociationExecutionsPaginated
      extends Effect[
        DescribeAssociationExecutionsRequest,
        AwsError,
        zio.aws.ssm.model.DescribeAssociationExecutionsResponse.ReadOnly
      ]
  object ListComplianceItems
      extends Stream[
        ListComplianceItemsRequest,
        AwsError,
        zio.aws.ssm.model.ComplianceItem.ReadOnly
      ]
  object ListComplianceItemsPaginated
      extends Effect[
        ListComplianceItemsRequest,
        AwsError,
        zio.aws.ssm.model.ListComplianceItemsResponse.ReadOnly
      ]
  object DescribeMaintenanceWindowTasks
      extends Stream[
        DescribeMaintenanceWindowTasksRequest,
        AwsError,
        zio.aws.ssm.model.MaintenanceWindowTask.ReadOnly
      ]
  object DescribeMaintenanceWindowTasksPaginated
      extends Effect[
        DescribeMaintenanceWindowTasksRequest,
        AwsError,
        zio.aws.ssm.model.DescribeMaintenanceWindowTasksResponse.ReadOnly
      ]
  object DeleteMaintenanceWindow
      extends Effect[
        DeleteMaintenanceWindowRequest,
        AwsError,
        zio.aws.ssm.model.DeleteMaintenanceWindowResponse.ReadOnly
      ]
  object DescribePatchGroupState
      extends Effect[
        DescribePatchGroupStateRequest,
        AwsError,
        zio.aws.ssm.model.DescribePatchGroupStateResponse.ReadOnly
      ]
  object DescribeParameters
      extends Stream[
        DescribeParametersRequest,
        AwsError,
        zio.aws.ssm.model.ParameterMetadata.ReadOnly
      ]
  object DescribeParametersPaginated
      extends Effect[
        DescribeParametersRequest,
        AwsError,
        zio.aws.ssm.model.DescribeParametersResponse.ReadOnly
      ]
  object ListOpsItemEvents
      extends Stream[
        ListOpsItemEventsRequest,
        AwsError,
        zio.aws.ssm.model.OpsItemEventSummary.ReadOnly
      ]
  object ListOpsItemEventsPaginated
      extends Effect[
        ListOpsItemEventsRequest,
        AwsError,
        zio.aws.ssm.model.ListOpsItemEventsResponse.ReadOnly
      ]
  object GetDocument
      extends Effect[
        GetDocumentRequest,
        AwsError,
        zio.aws.ssm.model.GetDocumentResponse.ReadOnly
      ]
  object CreateDocument
      extends Effect[
        CreateDocumentRequest,
        AwsError,
        zio.aws.ssm.model.CreateDocumentResponse.ReadOnly
      ]
  object ModifyDocumentPermission
      extends Effect[
        ModifyDocumentPermissionRequest,
        AwsError,
        zio.aws.ssm.model.ModifyDocumentPermissionResponse.ReadOnly
      ]
  object PutResourcePolicy
      extends Effect[
        PutResourcePolicyRequest,
        AwsError,
        zio.aws.ssm.model.PutResourcePolicyResponse.ReadOnly
      ]
  object RegisterTargetWithMaintenanceWindow
      extends Effect[
        RegisterTargetWithMaintenanceWindowRequest,
        AwsError,
        zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse.ReadOnly
      ]
  object TerminateSession
      extends Effect[
        TerminateSessionRequest,
        AwsError,
        zio.aws.ssm.model.TerminateSessionResponse.ReadOnly
      ]
  object RemoveTagsFromResource
      extends Effect[
        RemoveTagsFromResourceRequest,
        AwsError,
        zio.aws.ssm.model.RemoveTagsFromResourceResponse.ReadOnly
      ]
  object StartChangeRequestExecution
      extends Effect[
        StartChangeRequestExecutionRequest,
        AwsError,
        zio.aws.ssm.model.StartChangeRequestExecutionResponse.ReadOnly
      ]
  object DescribeActivations
      extends Stream[
        DescribeActivationsRequest,
        AwsError,
        zio.aws.ssm.model.Activation.ReadOnly
      ]
  object DescribeActivationsPaginated
      extends Effect[
        DescribeActivationsRequest,
        AwsError,
        zio.aws.ssm.model.DescribeActivationsResponse.ReadOnly
      ]
  object SendAutomationSignal
      extends Effect[
        SendAutomationSignalRequest,
        AwsError,
        zio.aws.ssm.model.SendAutomationSignalResponse.ReadOnly
      ]
  object CreateMaintenanceWindow
      extends Effect[
        CreateMaintenanceWindowRequest,
        AwsError,
        zio.aws.ssm.model.CreateMaintenanceWindowResponse.ReadOnly
      ]
  object CancelCommand
      extends Effect[
        CancelCommandRequest,
        AwsError,
        zio.aws.ssm.model.CancelCommandResponse.ReadOnly
      ]
  object GetMaintenanceWindow
      extends Effect[
        GetMaintenanceWindowRequest,
        AwsError,
        zio.aws.ssm.model.GetMaintenanceWindowResponse.ReadOnly
      ]
  object DescribeAssociation
      extends Effect[
        DescribeAssociationRequest,
        AwsError,
        zio.aws.ssm.model.DescribeAssociationResponse.ReadOnly
      ]
  object GetMaintenanceWindowExecutionTask
      extends Effect[
        GetMaintenanceWindowExecutionTaskRequest,
        AwsError,
        zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse.ReadOnly
      ]
  object LabelParameterVersion
      extends Effect[
        LabelParameterVersionRequest,
        AwsError,
        zio.aws.ssm.model.LabelParameterVersionResponse.ReadOnly
      ]
  object DescribePatchProperties
      extends Stream[
        DescribePatchPropertiesRequest,
        AwsError,
        Map[AttributeName, AttributeValue]
      ]
  object DescribePatchPropertiesPaginated
      extends Effect[
        DescribePatchPropertiesRequest,
        AwsError,
        zio.aws.ssm.model.DescribePatchPropertiesResponse.ReadOnly
      ]
  object DescribeMaintenanceWindowSchedule
      extends Stream[
        DescribeMaintenanceWindowScheduleRequest,
        AwsError,
        zio.aws.ssm.model.ScheduledWindowExecution.ReadOnly
      ]
  object DescribeMaintenanceWindowSchedulePaginated
      extends Effect[
        DescribeMaintenanceWindowScheduleRequest,
        AwsError,
        zio.aws.ssm.model.DescribeMaintenanceWindowScheduleResponse.ReadOnly
      ]
  object GetDefaultPatchBaseline
      extends Effect[
        GetDefaultPatchBaselineRequest,
        AwsError,
        zio.aws.ssm.model.GetDefaultPatchBaselineResponse.ReadOnly
      ]
  object UpdateDocumentMetadata
      extends Effect[
        UpdateDocumentMetadataRequest,
        AwsError,
        zio.aws.ssm.model.UpdateDocumentMetadataResponse.ReadOnly
      ]
  object DeleteAssociation
      extends Effect[
        DeleteAssociationRequest,
        AwsError,
        zio.aws.ssm.model.DeleteAssociationResponse.ReadOnly
      ]
  object CreateAssociationBatch
      extends Effect[
        CreateAssociationBatchRequest,
        AwsError,
        zio.aws.ssm.model.CreateAssociationBatchResponse.ReadOnly
      ]
  object GetParameter
      extends Effect[
        GetParameterRequest,
        AwsError,
        zio.aws.ssm.model.GetParameterResponse.ReadOnly
      ]
  object RegisterTaskWithMaintenanceWindow
      extends Effect[
        RegisterTaskWithMaintenanceWindowRequest,
        AwsError,
        zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse.ReadOnly
      ]
  object ListOpsMetadata
      extends Stream[
        ListOpsMetadataRequest,
        AwsError,
        zio.aws.ssm.model.OpsMetadata.ReadOnly
      ]
  object ListOpsMetadataPaginated
      extends Effect[
        ListOpsMetadataRequest,
        AwsError,
        zio.aws.ssm.model.ListOpsMetadataResponse.ReadOnly
      ]
  object RegisterPatchBaselineForPatchGroup
      extends Effect[
        RegisterPatchBaselineForPatchGroupRequest,
        AwsError,
        zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupResponse.ReadOnly
      ]
  object DescribeInstancePatchStatesForPatchGroup
      extends Stream[
        DescribeInstancePatchStatesForPatchGroupRequest,
        AwsError,
        zio.aws.ssm.model.InstancePatchState.ReadOnly
      ]
  object DescribeInstancePatchStatesForPatchGroupPaginated
      extends Effect[
        DescribeInstancePatchStatesForPatchGroupRequest,
        AwsError,
        zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse.ReadOnly
      ]
  object ListDocuments
      extends Stream[
        ListDocumentsRequest,
        AwsError,
        zio.aws.ssm.model.DocumentIdentifier.ReadOnly
      ]
  object ListDocumentsPaginated
      extends Effect[
        ListDocumentsRequest,
        AwsError,
        zio.aws.ssm.model.ListDocumentsResponse.ReadOnly
      ]
  object GetPatchBaseline
      extends Effect[
        GetPatchBaselineRequest,
        AwsError,
        zio.aws.ssm.model.GetPatchBaselineResponse.ReadOnly
      ]
  object UpdateMaintenanceWindowTarget
      extends Effect[
        UpdateMaintenanceWindowTargetRequest,
        AwsError,
        zio.aws.ssm.model.UpdateMaintenanceWindowTargetResponse.ReadOnly
      ]
  object StartAutomationExecution
      extends Effect[
        StartAutomationExecutionRequest,
        AwsError,
        zio.aws.ssm.model.StartAutomationExecutionResponse.ReadOnly
      ]
  object SendCommand
      extends Effect[
        SendCommandRequest,
        AwsError,
        zio.aws.ssm.model.SendCommandResponse.ReadOnly
      ]
  object GetInventory
      extends Stream[
        GetInventoryRequest,
        AwsError,
        zio.aws.ssm.model.InventoryResultEntity.ReadOnly
      ]
  object GetInventoryPaginated
      extends Effect[
        GetInventoryRequest,
        AwsError,
        zio.aws.ssm.model.GetInventoryResponse.ReadOnly
      ]
  object UpdateServiceSetting
      extends Effect[
        UpdateServiceSettingRequest,
        AwsError,
        zio.aws.ssm.model.UpdateServiceSettingResponse.ReadOnly
      ]
  object GetConnectionStatus
      extends Effect[
        GetConnectionStatusRequest,
        AwsError,
        zio.aws.ssm.model.GetConnectionStatusResponse.ReadOnly
      ]
  object DescribeAutomationExecutions
      extends Stream[
        DescribeAutomationExecutionsRequest,
        AwsError,
        zio.aws.ssm.model.AutomationExecutionMetadata.ReadOnly
      ]
  object DescribeAutomationExecutionsPaginated
      extends Effect[DescribeAutomationExecutionsRequest, AwsError, ReadOnly]
  object ResumeSession
      extends Effect[
        ResumeSessionRequest,
        AwsError,
        zio.aws.ssm.model.ResumeSessionResponse.ReadOnly
      ]
  object ListResourceComplianceSummaries
      extends Stream[
        ListResourceComplianceSummariesRequest,
        AwsError,
        zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly
      ]
  object ListResourceComplianceSummariesPaginated
      extends Effect[
        ListResourceComplianceSummariesRequest,
        AwsError,
        zio.aws.ssm.model.ListResourceComplianceSummariesResponse.ReadOnly
      ]
  object CreatePatchBaseline
      extends Effect[
        CreatePatchBaselineRequest,
        AwsError,
        zio.aws.ssm.model.CreatePatchBaselineResponse.ReadOnly
      ]
  object GetOpsItem
      extends Effect[
        GetOpsItemRequest,
        AwsError,
        zio.aws.ssm.model.GetOpsItemResponse.ReadOnly
      ]
  object GetPatchBaselineForPatchGroup
      extends Effect[
        GetPatchBaselineForPatchGroupRequest,
        AwsError,
        zio.aws.ssm.model.GetPatchBaselineForPatchGroupResponse.ReadOnly
      ]
  object CreateAssociation
      extends Effect[
        CreateAssociationRequest,
        AwsError,
        zio.aws.ssm.model.CreateAssociationResponse.ReadOnly
      ]
  object ListAssociations
      extends Stream[
        ListAssociationsRequest,
        AwsError,
        zio.aws.ssm.model.Association.ReadOnly
      ]
  object ListAssociationsPaginated
      extends Effect[
        ListAssociationsRequest,
        AwsError,
        zio.aws.ssm.model.ListAssociationsResponse.ReadOnly
      ]
  object UpdateDocument
      extends Effect[
        UpdateDocumentRequest,
        AwsError,
        zio.aws.ssm.model.UpdateDocumentResponse.ReadOnly
      ]
  object PutInventory
      extends Effect[
        PutInventoryRequest,
        AwsError,
        zio.aws.ssm.model.PutInventoryResponse.ReadOnly
      ]
  object UpdateMaintenanceWindow
      extends Effect[
        UpdateMaintenanceWindowRequest,
        AwsError,
        zio.aws.ssm.model.UpdateMaintenanceWindowResponse.ReadOnly
      ]
  object UpdateDocumentDefaultVersion
      extends Effect[
        UpdateDocumentDefaultVersionRequest,
        AwsError,
        zio.aws.ssm.model.UpdateDocumentDefaultVersionResponse.ReadOnly
      ]
  object GetMaintenanceWindowTask
      extends Effect[
        GetMaintenanceWindowTaskRequest,
        AwsError,
        zio.aws.ssm.model.GetMaintenanceWindowTaskResponse.ReadOnly
      ]
  object DescribeAssociationExecutionTargets
      extends Stream[
        DescribeAssociationExecutionTargetsRequest,
        AwsError,
        zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly
      ]
  object DescribeAssociationExecutionTargetsPaginated
      extends Effect[
        DescribeAssociationExecutionTargetsRequest,
        AwsError,
        zio.aws.ssm.model.DescribeAssociationExecutionTargetsResponse.ReadOnly
      ]
  object CreateOpsItem
      extends Effect[
        CreateOpsItemRequest,
        AwsError,
        zio.aws.ssm.model.CreateOpsItemResponse.ReadOnly
      ]
  object ListCommands
      extends Stream[
        ListCommandsRequest,
        AwsError,
        zio.aws.ssm.model.Command.ReadOnly
      ]
  object ListCommandsPaginated
      extends Effect[
        ListCommandsRequest,
        AwsError,
        zio.aws.ssm.model.ListCommandsResponse.ReadOnly
      ]
  object GetAutomationExecution
      extends Effect[
        GetAutomationExecutionRequest,
        AwsError,
        zio.aws.ssm.model.GetAutomationExecutionResponse.ReadOnly
      ]
  object DescribeMaintenanceWindowExecutionTasks
      extends Stream[
        DescribeMaintenanceWindowExecutionTasksRequest,
        AwsError,
        zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.ReadOnly
      ]
  object DescribeMaintenanceWindowExecutionTasksPaginated
      extends Effect[
        DescribeMaintenanceWindowExecutionTasksRequest,
        AwsError,
        zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse.ReadOnly
      ]
  object ListDocumentVersions
      extends Stream[
        ListDocumentVersionsRequest,
        AwsError,
        zio.aws.ssm.model.DocumentVersionInfo.ReadOnly
      ]
  object ListDocumentVersionsPaginated
      extends Effect[
        ListDocumentVersionsRequest,
        AwsError,
        zio.aws.ssm.model.ListDocumentVersionsResponse.ReadOnly
      ]
  object GetOpsSummary
      extends Stream[
        GetOpsSummaryRequest,
        AwsError,
        zio.aws.ssm.model.OpsEntity.ReadOnly
      ]
  object GetOpsSummaryPaginated
      extends Effect[
        GetOpsSummaryRequest,
        AwsError,
        zio.aws.ssm.model.GetOpsSummaryResponse.ReadOnly
      ]
  object DescribeDocument
      extends Effect[
        DescribeDocumentRequest,
        AwsError,
        zio.aws.ssm.model.DescribeDocumentResponse.ReadOnly
      ]
  object DescribePatchGroups
      extends Stream[
        DescribePatchGroupsRequest,
        AwsError,
        zio.aws.ssm.model.PatchGroupPatchBaselineMapping.ReadOnly
      ]
  object DescribePatchGroupsPaginated
      extends Effect[
        DescribePatchGroupsRequest,
        AwsError,
        zio.aws.ssm.model.DescribePatchGroupsResponse.ReadOnly
      ]
  object StartAssociationsOnce
      extends Effect[
        StartAssociationsOnceRequest,
        AwsError,
        zio.aws.ssm.model.StartAssociationsOnceResponse.ReadOnly
      ]
  object DeleteResourcePolicy
      extends Effect[
        DeleteResourcePolicyRequest,
        AwsError,
        zio.aws.ssm.model.DeleteResourcePolicyResponse.ReadOnly
      ]
  object DescribeMaintenanceWindowTargets
      extends Stream[
        DescribeMaintenanceWindowTargetsRequest,
        AwsError,
        zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly
      ]
  object DescribeMaintenanceWindowTargetsPaginated
      extends Effect[
        DescribeMaintenanceWindowTargetsRequest,
        AwsError,
        zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse.ReadOnly
      ]
  object UpdateManagedInstanceRole
      extends Effect[
        UpdateManagedInstanceRoleRequest,
        AwsError,
        zio.aws.ssm.model.UpdateManagedInstanceRoleResponse.ReadOnly
      ]
  object DescribeInstanceInformation
      extends Stream[
        DescribeInstanceInformationRequest,
        AwsError,
        zio.aws.ssm.model.InstanceInformation.ReadOnly
      ]
  object DescribeInstanceInformationPaginated
      extends Effect[
        DescribeInstanceInformationRequest,
        AwsError,
        zio.aws.ssm.model.DescribeInstanceInformationResponse.ReadOnly
      ]
  object UpdateMaintenanceWindowTask
      extends Effect[
        UpdateMaintenanceWindowTaskRequest,
        AwsError,
        zio.aws.ssm.model.UpdateMaintenanceWindowTaskResponse.ReadOnly
      ]
  object DescribeMaintenanceWindows
      extends Stream[
        DescribeMaintenanceWindowsRequest,
        AwsError,
        zio.aws.ssm.model.MaintenanceWindowIdentity.ReadOnly
      ]
  object DescribeMaintenanceWindowsPaginated
      extends Effect[
        DescribeMaintenanceWindowsRequest,
        AwsError,
        zio.aws.ssm.model.DescribeMaintenanceWindowsResponse.ReadOnly
      ]
  object GetServiceSetting
      extends Effect[
        GetServiceSettingRequest,
        AwsError,
        zio.aws.ssm.model.GetServiceSettingResponse.ReadOnly
      ]
  object DeleteOpsItem
      extends Effect[
        DeleteOpsItemRequest,
        AwsError,
        zio.aws.ssm.model.DeleteOpsItemResponse.ReadOnly
      ]
  object RegisterDefaultPatchBaseline
      extends Effect[
        RegisterDefaultPatchBaselineRequest,
        AwsError,
        zio.aws.ssm.model.RegisterDefaultPatchBaselineResponse.ReadOnly
      ]
  object ListDocumentMetadataHistory
      extends Effect[
        ListDocumentMetadataHistoryRequest,
        AwsError,
        zio.aws.ssm.model.ListDocumentMetadataHistoryResponse.ReadOnly
      ]
  object GetParametersByPath
      extends Stream[
        GetParametersByPathRequest,
        AwsError,
        zio.aws.ssm.model.Parameter.ReadOnly
      ]
  object GetParametersByPathPaginated
      extends Effect[
        GetParametersByPathRequest,
        AwsError,
        zio.aws.ssm.model.GetParametersByPathResponse.ReadOnly
      ]
  object CancelMaintenanceWindowExecution
      extends Effect[
        CancelMaintenanceWindowExecutionRequest,
        AwsError,
        zio.aws.ssm.model.CancelMaintenanceWindowExecutionResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.ssm.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DescribeMaintenanceWindowExecutionTaskInvocations
      extends Stream[
        DescribeMaintenanceWindowExecutionTaskInvocationsRequest,
        AwsError,
        zio.aws.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity.ReadOnly
      ]
  object DescribeMaintenanceWindowExecutionTaskInvocationsPaginated
      extends Effect[
        DescribeMaintenanceWindowExecutionTaskInvocationsRequest,
        AwsError,
        zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse.ReadOnly
      ]
  object UpdateAssociation
      extends Effect[
        UpdateAssociationRequest,
        AwsError,
        zio.aws.ssm.model.UpdateAssociationResponse.ReadOnly
      ]
  object StartSession
      extends Effect[
        StartSessionRequest,
        AwsError,
        zio.aws.ssm.model.StartSessionResponse.ReadOnly
      ]
  object AssociateOpsItemRelatedItem
      extends Effect[
        AssociateOpsItemRelatedItemRequest,
        AwsError,
        zio.aws.ssm.model.AssociateOpsItemRelatedItemResponse.ReadOnly
      ]
  object DisassociateOpsItemRelatedItem
      extends Effect[
        DisassociateOpsItemRelatedItemRequest,
        AwsError,
        zio.aws.ssm.model.DisassociateOpsItemRelatedItemResponse.ReadOnly
      ]
  object DescribeOpsItems
      extends Stream[
        DescribeOpsItemsRequest,
        AwsError,
        zio.aws.ssm.model.OpsItemSummary.ReadOnly
      ]
  object DescribeOpsItemsPaginated
      extends Effect[
        DescribeOpsItemsRequest,
        AwsError,
        zio.aws.ssm.model.DescribeOpsItemsResponse.ReadOnly
      ]
  object DescribeEffectiveInstanceAssociations
      extends Stream[
        DescribeEffectiveInstanceAssociationsRequest,
        AwsError,
        zio.aws.ssm.model.InstanceAssociation.ReadOnly
      ]
  object DescribeEffectiveInstanceAssociationsPaginated
      extends Effect[
        DescribeEffectiveInstanceAssociationsRequest,
        AwsError,
        zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsResponse.ReadOnly
      ]
  object ListAssociationVersions
      extends Stream[
        ListAssociationVersionsRequest,
        AwsError,
        zio.aws.ssm.model.AssociationVersionInfo.ReadOnly
      ]
  object ListAssociationVersionsPaginated
      extends Effect[
        ListAssociationVersionsRequest,
        AwsError,
        zio.aws.ssm.model.ListAssociationVersionsResponse.ReadOnly
      ]
  object DescribeInstancePatches
      extends Stream[
        DescribeInstancePatchesRequest,
        AwsError,
        zio.aws.ssm.model.PatchComplianceData.ReadOnly
      ]
  object DescribeInstancePatchesPaginated
      extends Effect[
        DescribeInstancePatchesRequest,
        AwsError,
        zio.aws.ssm.model.DescribeInstancePatchesResponse.ReadOnly
      ]
  object GetDeployablePatchSnapshotForInstance
      extends Effect[
        GetDeployablePatchSnapshotForInstanceRequest,
        AwsError,
        zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse.ReadOnly
      ]
  object PutComplianceItems
      extends Effect[
        PutComplianceItemsRequest,
        AwsError,
        zio.aws.ssm.model.PutComplianceItemsResponse.ReadOnly
      ]
  object DeleteActivation
      extends Effect[
        DeleteActivationRequest,
        AwsError,
        zio.aws.ssm.model.DeleteActivationResponse.ReadOnly
      ]
  object ListOpsItemRelatedItems
      extends Stream[
        ListOpsItemRelatedItemsRequest,
        AwsError,
        zio.aws.ssm.model.OpsItemRelatedItemSummary.ReadOnly
      ]
  object ListOpsItemRelatedItemsPaginated
      extends Effect[
        ListOpsItemRelatedItemsRequest,
        AwsError,
        zio.aws.ssm.model.ListOpsItemRelatedItemsResponse.ReadOnly
      ]
  object DeleteParameter
      extends Effect[
        DeleteParameterRequest,
        AwsError,
        zio.aws.ssm.model.DeleteParameterResponse.ReadOnly
      ]
  object DescribeInventoryDeletions
      extends Stream[
        DescribeInventoryDeletionsRequest,
        AwsError,
        zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly
      ]
  object DescribeInventoryDeletionsPaginated
      extends Effect[
        DescribeInventoryDeletionsRequest,
        AwsError,
        zio.aws.ssm.model.DescribeInventoryDeletionsResponse.ReadOnly
      ]
  object GetCommandInvocation
      extends Effect[
        GetCommandInvocationRequest,
        AwsError,
        zio.aws.ssm.model.GetCommandInvocationResponse.ReadOnly
      ]
  object UpdateAssociationStatus
      extends Effect[
        UpdateAssociationStatusRequest,
        AwsError,
        zio.aws.ssm.model.UpdateAssociationStatusResponse.ReadOnly
      ]
  object UpdateOpsMetadata
      extends Effect[
        UpdateOpsMetadataRequest,
        AwsError,
        zio.aws.ssm.model.UpdateOpsMetadataResponse.ReadOnly
      ]
  object DescribePatchBaselines
      extends Stream[
        DescribePatchBaselinesRequest,
        AwsError,
        zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly
      ]
  object DescribePatchBaselinesPaginated
      extends Effect[
        DescribePatchBaselinesRequest,
        AwsError,
        zio.aws.ssm.model.DescribePatchBaselinesResponse.ReadOnly
      ]
  object DescribeEffectivePatchesForPatchBaseline
      extends Stream[
        DescribeEffectivePatchesForPatchBaselineRequest,
        AwsError,
        zio.aws.ssm.model.EffectivePatch.ReadOnly
      ]
  object DescribeEffectivePatchesForPatchBaselinePaginated
      extends Effect[
        DescribeEffectivePatchesForPatchBaselineRequest,
        AwsError,
        zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse.ReadOnly
      ]
  object CreateActivation
      extends Effect[
        CreateActivationRequest,
        AwsError,
        zio.aws.ssm.model.CreateActivationResponse.ReadOnly
      ]
  object GetMaintenanceWindowExecution
      extends Effect[
        GetMaintenanceWindowExecutionRequest,
        AwsError,
        zio.aws.ssm.model.GetMaintenanceWindowExecutionResponse.ReadOnly
      ]
  object DeregisterTaskFromMaintenanceWindow
      extends Effect[
        DeregisterTaskFromMaintenanceWindowRequest,
        AwsError,
        zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowResponse.ReadOnly
      ]
  object DeleteDocument
      extends Effect[
        DeleteDocumentRequest,
        AwsError,
        zio.aws.ssm.model.DeleteDocumentResponse.ReadOnly
      ]
  object CreateResourceDataSync
      extends Effect[
        CreateResourceDataSyncRequest,
        AwsError,
        zio.aws.ssm.model.CreateResourceDataSyncResponse.ReadOnly
      ]
  object GetMaintenanceWindowExecutionTaskInvocation
      extends Effect[
        GetMaintenanceWindowExecutionTaskInvocationRequest,
        AwsError,
        zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse.ReadOnly
      ]
  object DeregisterManagedInstance
      extends Effect[
        DeregisterManagedInstanceRequest,
        AwsError,
        zio.aws.ssm.model.DeregisterManagedInstanceResponse.ReadOnly
      ]
  object UpdateOpsItem
      extends Effect[
        UpdateOpsItemRequest,
        AwsError,
        zio.aws.ssm.model.UpdateOpsItemResponse.ReadOnly
      ]
  object DeleteOpsMetadata
      extends Effect[
        DeleteOpsMetadataRequest,
        AwsError,
        zio.aws.ssm.model.DeleteOpsMetadataResponse.ReadOnly
      ]
  object DescribeAvailablePatches
      extends Stream[
        DescribeAvailablePatchesRequest,
        AwsError,
        zio.aws.ssm.model.Patch.ReadOnly
      ]
  object DescribeAvailablePatchesPaginated
      extends Effect[
        DescribeAvailablePatchesRequest,
        AwsError,
        zio.aws.ssm.model.DescribeAvailablePatchesResponse.ReadOnly
      ]
  object ListComplianceSummaries
      extends Stream[
        ListComplianceSummariesRequest,
        AwsError,
        zio.aws.ssm.model.ComplianceSummaryItem.ReadOnly
      ]
  object ListComplianceSummariesPaginated
      extends Effect[
        ListComplianceSummariesRequest,
        AwsError,
        zio.aws.ssm.model.ListComplianceSummariesResponse.ReadOnly
      ]
  object DeletePatchBaseline
      extends Effect[
        DeletePatchBaselineRequest,
        AwsError,
        zio.aws.ssm.model.DeletePatchBaselineResponse.ReadOnly
      ]
  object CreateOpsMetadata
      extends Effect[
        CreateOpsMetadataRequest,
        AwsError,
        zio.aws.ssm.model.CreateOpsMetadataResponse.ReadOnly
      ]
  object DeregisterTargetFromMaintenanceWindow
      extends Effect[
        DeregisterTargetFromMaintenanceWindowRequest,
        AwsError,
        zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowResponse.ReadOnly
      ]
  object PutParameter
      extends Effect[
        PutParameterRequest,
        AwsError,
        zio.aws.ssm.model.PutParameterResponse.ReadOnly
      ]
  object DescribeDocumentPermission
      extends Effect[
        DescribeDocumentPermissionRequest,
        AwsError,
        zio.aws.ssm.model.DescribeDocumentPermissionResponse.ReadOnly
      ]
  object ResetServiceSetting
      extends Effect[
        ResetServiceSettingRequest,
        AwsError,
        zio.aws.ssm.model.ResetServiceSettingResponse.ReadOnly
      ]
  object UpdateResourceDataSync
      extends Effect[
        UpdateResourceDataSyncRequest,
        AwsError,
        zio.aws.ssm.model.UpdateResourceDataSyncResponse.ReadOnly
      ]
  object UnlabelParameterVersion
      extends Effect[
        UnlabelParameterVersionRequest,
        AwsError,
        zio.aws.ssm.model.UnlabelParameterVersionResponse.ReadOnly
      ]
  object GetInventorySchema
      extends Stream[
        GetInventorySchemaRequest,
        AwsError,
        zio.aws.ssm.model.InventoryItemSchema.ReadOnly
      ]
  object GetInventorySchemaPaginated
      extends Effect[
        GetInventorySchemaRequest,
        AwsError,
        zio.aws.ssm.model.GetInventorySchemaResponse.ReadOnly
      ]
  object GetCalendarState
      extends Effect[
        GetCalendarStateRequest,
        AwsError,
        zio.aws.ssm.model.GetCalendarStateResponse.ReadOnly
      ]
  object ListCommandInvocations
      extends Stream[
        ListCommandInvocationsRequest,
        AwsError,
        zio.aws.ssm.model.CommandInvocation.ReadOnly
      ]
  object ListCommandInvocationsPaginated
      extends Effect[
        ListCommandInvocationsRequest,
        AwsError,
        zio.aws.ssm.model.ListCommandInvocationsResponse.ReadOnly
      ]
  object DeleteResourceDataSync
      extends Effect[
        DeleteResourceDataSyncRequest,
        AwsError,
        zio.aws.ssm.model.DeleteResourceDataSyncResponse.ReadOnly
      ]
  object GetResourcePolicies
      extends Stream[
        GetResourcePoliciesRequest,
        AwsError,
        zio.aws.ssm.model.GetResourcePoliciesResponseEntry.ReadOnly
      ]
  object GetResourcePoliciesPaginated
      extends Effect[
        GetResourcePoliciesRequest,
        AwsError,
        zio.aws.ssm.model.GetResourcePoliciesResponse.ReadOnly
      ]
  object UpdatePatchBaseline
      extends Effect[
        UpdatePatchBaselineRequest,
        AwsError,
        zio.aws.ssm.model.UpdatePatchBaselineResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Ssm] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Ssm] { rts =>
        ZIO.succeed {
          new Ssm {
            val api: SsmAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Ssm = this
            def deleteInventory(request: DeleteInventoryRequest): IO[
              AwsError,
              zio.aws.ssm.model.DeleteInventoryResponse.ReadOnly
            ] = proxy(DeleteInventory, request)
            def describeAutomationStepExecutions(
                request: DescribeAutomationStepExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.StepExecution.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeAutomationStepExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeAutomationStepExecutionsPaginated(
                request: DescribeAutomationStepExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeAutomationStepExecutionsResponse.ReadOnly
            ] = proxy(DescribeAutomationStepExecutionsPaginated, request)
            def deleteParameters(request: DeleteParametersRequest): IO[
              AwsError,
              zio.aws.ssm.model.DeleteParametersResponse.ReadOnly
            ] = proxy(DeleteParameters, request)
            def getParameterHistory(
                request: GetParameterHistoryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.ParameterHistory.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetParameterHistory, request)
                }
                .getOrThrowFiberFailure()
            }
            def getParameterHistoryPaginated(
                request: GetParameterHistoryRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.GetParameterHistoryResponse.ReadOnly
            ] = proxy(GetParameterHistoryPaginated, request)
            def addTagsToResource(request: AddTagsToResourceRequest): IO[
              AwsError,
              zio.aws.ssm.model.AddTagsToResourceResponse.ReadOnly
            ] = proxy(AddTagsToResource, request)
            def describeSessions(
                request: DescribeSessionsRequest
            ): ZStream[Any, AwsError, zio.aws.ssm.model.Session.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeSessions, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeSessionsPaginated(request: DescribeSessionsRequest): IO[
              AwsError,
              zio.aws.ssm.model.DescribeSessionsResponse.ReadOnly
            ] = proxy(DescribeSessionsPaginated, request)
            def listResourceDataSync(
                request: ListResourceDataSyncRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.ResourceDataSyncItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListResourceDataSync, request)
                }
                .getOrThrowFiberFailure()
            }
            def listResourceDataSyncPaginated(
                request: ListResourceDataSyncRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.ListResourceDataSyncResponse.ReadOnly
            ] = proxy(ListResourceDataSyncPaginated, request)
            def getOpsMetadata(
                request: GetOpsMetadataRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly,
              Tuple2[MetadataKey, zio.aws.ssm.model.MetadataValue.ReadOnly]
            ]] = proxy(GetOpsMetadata, request)
            def getOpsMetadataPaginated(
                request: GetOpsMetadataRequest
            ): IO[AwsError, zio.aws.ssm.model.GetOpsMetadataResponse.ReadOnly] =
              proxy(GetOpsMetadataPaginated, request)
            def deregisterPatchBaselineForPatchGroup(
                request: DeregisterPatchBaselineForPatchGroupRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DeregisterPatchBaselineForPatchGroupResponse.ReadOnly
            ] = proxy(DeregisterPatchBaselineForPatchGroup, request)
            def stopAutomationExecution(
                request: StopAutomationExecutionRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.StopAutomationExecutionResponse.ReadOnly
            ] = proxy(StopAutomationExecution, request)
            def describeInstanceAssociationsStatus(
                request: DescribeInstanceAssociationsStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeInstanceAssociationsStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeInstanceAssociationsStatusPaginated(
                request: DescribeInstanceAssociationsStatusRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeInstanceAssociationsStatusResponse.ReadOnly
            ] = proxy(DescribeInstanceAssociationsStatusPaginated, request)
            def describeMaintenanceWindowsForTarget(
                request: DescribeMaintenanceWindowsForTargetRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.MaintenanceWindowIdentityForTarget.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeMaintenanceWindowsForTarget, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeMaintenanceWindowsForTargetPaginated(
                request: DescribeMaintenanceWindowsForTargetRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeMaintenanceWindowsForTargetResponse.ReadOnly
            ] = proxy(DescribeMaintenanceWindowsForTargetPaginated, request)
            def getParameters(
                request: GetParametersRequest
            ): IO[AwsError, zio.aws.ssm.model.GetParametersResponse.ReadOnly] =
              proxy(GetParameters, request)
            def describeInstancePatchStates(
                request: DescribeInstancePatchStatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.InstancePatchState.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeInstancePatchStates, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeInstancePatchStatesPaginated(
                request: DescribeInstancePatchStatesRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeInstancePatchStatesResponse.ReadOnly
            ] = proxy(DescribeInstancePatchStatesPaginated, request)
            def listInventoryEntries(
                request: ListInventoryEntriesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly,
              Map[AttributeName, AttributeValue]
            ]] = proxy(ListInventoryEntries, request)
            def listInventoryEntriesPaginated(
                request: ListInventoryEntriesRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.ListInventoryEntriesResponse.ReadOnly
            ] = proxy(ListInventoryEntriesPaginated, request)
            def describeMaintenanceWindowExecutions(
                request: DescribeMaintenanceWindowExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.MaintenanceWindowExecution.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeMaintenanceWindowExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeMaintenanceWindowExecutionsPaginated(
                request: DescribeMaintenanceWindowExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeMaintenanceWindowExecutionsResponse.ReadOnly
            ] = proxy(DescribeMaintenanceWindowExecutionsPaginated, request)
            def describeAssociationExecutions(
                request: DescribeAssociationExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.AssociationExecution.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeAssociationExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeAssociationExecutionsPaginated(
                request: DescribeAssociationExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeAssociationExecutionsResponse.ReadOnly
            ] = proxy(DescribeAssociationExecutionsPaginated, request)
            def listComplianceItems(
                request: ListComplianceItemsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.ComplianceItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListComplianceItems, request)
                }
                .getOrThrowFiberFailure()
            }
            def listComplianceItemsPaginated(
                request: ListComplianceItemsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.ListComplianceItemsResponse.ReadOnly
            ] = proxy(ListComplianceItemsPaginated, request)
            def describeMaintenanceWindowTasks(
                request: DescribeMaintenanceWindowTasksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.MaintenanceWindowTask.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeMaintenanceWindowTasks, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeMaintenanceWindowTasksPaginated(
                request: DescribeMaintenanceWindowTasksRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeMaintenanceWindowTasksResponse.ReadOnly
            ] = proxy(DescribeMaintenanceWindowTasksPaginated, request)
            def deleteMaintenanceWindow(
                request: DeleteMaintenanceWindowRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DeleteMaintenanceWindowResponse.ReadOnly
            ] = proxy(DeleteMaintenanceWindow, request)
            def describePatchGroupState(
                request: DescribePatchGroupStateRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribePatchGroupStateResponse.ReadOnly
            ] = proxy(DescribePatchGroupState, request)
            def describeParameters(request: DescribeParametersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.ParameterMetadata.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeParameters, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeParametersPaginated(
                request: DescribeParametersRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeParametersResponse.ReadOnly
            ] = proxy(DescribeParametersPaginated, request)
            def listOpsItemEvents(request: ListOpsItemEventsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.OpsItemEventSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListOpsItemEvents, request)
                }
                .getOrThrowFiberFailure()
            }
            def listOpsItemEventsPaginated(
                request: ListOpsItemEventsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.ListOpsItemEventsResponse.ReadOnly
            ] = proxy(ListOpsItemEventsPaginated, request)
            def getDocument(
                request: GetDocumentRequest
            ): IO[AwsError, zio.aws.ssm.model.GetDocumentResponse.ReadOnly] =
              proxy(GetDocument, request)
            def createDocument(
                request: CreateDocumentRequest
            ): IO[AwsError, zio.aws.ssm.model.CreateDocumentResponse.ReadOnly] =
              proxy(CreateDocument, request)
            def modifyDocumentPermission(
                request: ModifyDocumentPermissionRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.ModifyDocumentPermissionResponse.ReadOnly
            ] = proxy(ModifyDocumentPermission, request)
            def putResourcePolicy(request: PutResourcePolicyRequest): IO[
              AwsError,
              zio.aws.ssm.model.PutResourcePolicyResponse.ReadOnly
            ] = proxy(PutResourcePolicy, request)
            def registerTargetWithMaintenanceWindow(
                request: RegisterTargetWithMaintenanceWindowRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse.ReadOnly
            ] = proxy(RegisterTargetWithMaintenanceWindow, request)
            def terminateSession(request: TerminateSessionRequest): IO[
              AwsError,
              zio.aws.ssm.model.TerminateSessionResponse.ReadOnly
            ] = proxy(TerminateSession, request)
            def removeTagsFromResource(
                request: RemoveTagsFromResourceRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.RemoveTagsFromResourceResponse.ReadOnly
            ] = proxy(RemoveTagsFromResource, request)
            def startChangeRequestExecution(
                request: StartChangeRequestExecutionRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.StartChangeRequestExecutionResponse.ReadOnly
            ] = proxy(StartChangeRequestExecution, request)
            def describeActivations(
                request: DescribeActivationsRequest
            ): ZStream[Any, AwsError, zio.aws.ssm.model.Activation.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeActivations, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeActivationsPaginated(
                request: DescribeActivationsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeActivationsResponse.ReadOnly
            ] = proxy(DescribeActivationsPaginated, request)
            def sendAutomationSignal(request: SendAutomationSignalRequest): IO[
              AwsError,
              zio.aws.ssm.model.SendAutomationSignalResponse.ReadOnly
            ] = proxy(SendAutomationSignal, request)
            def createMaintenanceWindow(
                request: CreateMaintenanceWindowRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.CreateMaintenanceWindowResponse.ReadOnly
            ] = proxy(CreateMaintenanceWindow, request)
            def cancelCommand(
                request: CancelCommandRequest
            ): IO[AwsError, zio.aws.ssm.model.CancelCommandResponse.ReadOnly] =
              proxy(CancelCommand, request)
            def getMaintenanceWindow(request: GetMaintenanceWindowRequest): IO[
              AwsError,
              zio.aws.ssm.model.GetMaintenanceWindowResponse.ReadOnly
            ] = proxy(GetMaintenanceWindow, request)
            def describeAssociation(request: DescribeAssociationRequest): IO[
              AwsError,
              zio.aws.ssm.model.DescribeAssociationResponse.ReadOnly
            ] = proxy(DescribeAssociation, request)
            def getMaintenanceWindowExecutionTask(
                request: GetMaintenanceWindowExecutionTaskRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse.ReadOnly
            ] = proxy(GetMaintenanceWindowExecutionTask, request)
            def labelParameterVersion(
                request: LabelParameterVersionRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.LabelParameterVersionResponse.ReadOnly
            ] = proxy(LabelParameterVersion, request)
            def describePatchProperties(
                request: DescribePatchPropertiesRequest
            ): ZStream[Any, AwsError, Map[AttributeName, AttributeValue]] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribePatchProperties, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describePatchPropertiesPaginated(
                request: DescribePatchPropertiesRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribePatchPropertiesResponse.ReadOnly
            ] = proxy(DescribePatchPropertiesPaginated, request)
            def describeMaintenanceWindowSchedule(
                request: DescribeMaintenanceWindowScheduleRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.ScheduledWindowExecution.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeMaintenanceWindowSchedule, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeMaintenanceWindowSchedulePaginated(
                request: DescribeMaintenanceWindowScheduleRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeMaintenanceWindowScheduleResponse.ReadOnly
            ] = proxy(DescribeMaintenanceWindowSchedulePaginated, request)
            def getDefaultPatchBaseline(
                request: GetDefaultPatchBaselineRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.GetDefaultPatchBaselineResponse.ReadOnly
            ] = proxy(GetDefaultPatchBaseline, request)
            def updateDocumentMetadata(
                request: UpdateDocumentMetadataRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.UpdateDocumentMetadataResponse.ReadOnly
            ] = proxy(UpdateDocumentMetadata, request)
            def deleteAssociation(request: DeleteAssociationRequest): IO[
              AwsError,
              zio.aws.ssm.model.DeleteAssociationResponse.ReadOnly
            ] = proxy(DeleteAssociation, request)
            def createAssociationBatch(
                request: CreateAssociationBatchRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.CreateAssociationBatchResponse.ReadOnly
            ] = proxy(CreateAssociationBatch, request)
            def getParameter(
                request: GetParameterRequest
            ): IO[AwsError, zio.aws.ssm.model.GetParameterResponse.ReadOnly] =
              proxy(GetParameter, request)
            def registerTaskWithMaintenanceWindow(
                request: RegisterTaskWithMaintenanceWindowRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowResponse.ReadOnly
            ] = proxy(RegisterTaskWithMaintenanceWindow, request)
            def listOpsMetadata(
                request: ListOpsMetadataRequest
            ): ZStream[Any, AwsError, zio.aws.ssm.model.OpsMetadata.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListOpsMetadata, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listOpsMetadataPaginated(request: ListOpsMetadataRequest): IO[
              AwsError,
              zio.aws.ssm.model.ListOpsMetadataResponse.ReadOnly
            ] = proxy(ListOpsMetadataPaginated, request)
            def registerPatchBaselineForPatchGroup(
                request: RegisterPatchBaselineForPatchGroupRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.RegisterPatchBaselineForPatchGroupResponse.ReadOnly
            ] = proxy(RegisterPatchBaselineForPatchGroup, request)
            def describeInstancePatchStatesForPatchGroup(
                request: DescribeInstancePatchStatesForPatchGroupRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.InstancePatchState.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeInstancePatchStatesForPatchGroup, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeInstancePatchStatesForPatchGroupPaginated(
                request: DescribeInstancePatchStatesForPatchGroupRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse.ReadOnly
            ] =
              proxy(DescribeInstancePatchStatesForPatchGroupPaginated, request)
            def listDocuments(request: ListDocumentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.DocumentIdentifier.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDocuments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDocumentsPaginated(
                request: ListDocumentsRequest
            ): IO[AwsError, zio.aws.ssm.model.ListDocumentsResponse.ReadOnly] =
              proxy(ListDocumentsPaginated, request)
            def getPatchBaseline(request: GetPatchBaselineRequest): IO[
              AwsError,
              zio.aws.ssm.model.GetPatchBaselineResponse.ReadOnly
            ] = proxy(GetPatchBaseline, request)
            def updateMaintenanceWindowTarget(
                request: UpdateMaintenanceWindowTargetRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.UpdateMaintenanceWindowTargetResponse.ReadOnly
            ] = proxy(UpdateMaintenanceWindowTarget, request)
            def startAutomationExecution(
                request: StartAutomationExecutionRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.StartAutomationExecutionResponse.ReadOnly
            ] = proxy(StartAutomationExecution, request)
            def sendCommand(
                request: SendCommandRequest
            ): IO[AwsError, zio.aws.ssm.model.SendCommandResponse.ReadOnly] =
              proxy(SendCommand, request)
            def getInventory(request: GetInventoryRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.InventoryResultEntity.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetInventory, request)
                }
                .getOrThrowFiberFailure()
            }
            def getInventoryPaginated(
                request: GetInventoryRequest
            ): IO[AwsError, zio.aws.ssm.model.GetInventoryResponse.ReadOnly] =
              proxy(GetInventoryPaginated, request)
            def updateServiceSetting(request: UpdateServiceSettingRequest): IO[
              AwsError,
              zio.aws.ssm.model.UpdateServiceSettingResponse.ReadOnly
            ] = proxy(UpdateServiceSetting, request)
            def getConnectionStatus(request: GetConnectionStatusRequest): IO[
              AwsError,
              zio.aws.ssm.model.GetConnectionStatusResponse.ReadOnly
            ] = proxy(GetConnectionStatus, request)
            def describeAutomationExecutions(
                request: DescribeAutomationExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.AutomationExecutionMetadata.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeAutomationExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeAutomationExecutionsPaginated(
                request: DescribeAutomationExecutionsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(DescribeAutomationExecutionsPaginated, request)
            def resumeSession(
                request: ResumeSessionRequest
            ): IO[AwsError, zio.aws.ssm.model.ResumeSessionResponse.ReadOnly] =
              proxy(ResumeSession, request)
            def listResourceComplianceSummaries(
                request: ListResourceComplianceSummariesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListResourceComplianceSummaries, request)
                }
                .getOrThrowFiberFailure()
            }
            def listResourceComplianceSummariesPaginated(
                request: ListResourceComplianceSummariesRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.ListResourceComplianceSummariesResponse.ReadOnly
            ] = proxy(ListResourceComplianceSummariesPaginated, request)
            def createPatchBaseline(request: CreatePatchBaselineRequest): IO[
              AwsError,
              zio.aws.ssm.model.CreatePatchBaselineResponse.ReadOnly
            ] = proxy(CreatePatchBaseline, request)
            def getOpsItem(
                request: GetOpsItemRequest
            ): IO[AwsError, zio.aws.ssm.model.GetOpsItemResponse.ReadOnly] =
              proxy(GetOpsItem, request)
            def getPatchBaselineForPatchGroup(
                request: GetPatchBaselineForPatchGroupRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.GetPatchBaselineForPatchGroupResponse.ReadOnly
            ] = proxy(GetPatchBaselineForPatchGroup, request)
            def createAssociation(request: CreateAssociationRequest): IO[
              AwsError,
              zio.aws.ssm.model.CreateAssociationResponse.ReadOnly
            ] = proxy(CreateAssociation, request)
            def listAssociations(
                request: ListAssociationsRequest
            ): ZStream[Any, AwsError, zio.aws.ssm.model.Association.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListAssociations, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listAssociationsPaginated(request: ListAssociationsRequest): IO[
              AwsError,
              zio.aws.ssm.model.ListAssociationsResponse.ReadOnly
            ] = proxy(ListAssociationsPaginated, request)
            def updateDocument(
                request: UpdateDocumentRequest
            ): IO[AwsError, zio.aws.ssm.model.UpdateDocumentResponse.ReadOnly] =
              proxy(UpdateDocument, request)
            def putInventory(
                request: PutInventoryRequest
            ): IO[AwsError, zio.aws.ssm.model.PutInventoryResponse.ReadOnly] =
              proxy(PutInventory, request)
            def updateMaintenanceWindow(
                request: UpdateMaintenanceWindowRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.UpdateMaintenanceWindowResponse.ReadOnly
            ] = proxy(UpdateMaintenanceWindow, request)
            def updateDocumentDefaultVersion(
                request: UpdateDocumentDefaultVersionRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.UpdateDocumentDefaultVersionResponse.ReadOnly
            ] = proxy(UpdateDocumentDefaultVersion, request)
            def getMaintenanceWindowTask(
                request: GetMaintenanceWindowTaskRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.GetMaintenanceWindowTaskResponse.ReadOnly
            ] = proxy(GetMaintenanceWindowTask, request)
            def describeAssociationExecutionTargets(
                request: DescribeAssociationExecutionTargetsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeAssociationExecutionTargets, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeAssociationExecutionTargetsPaginated(
                request: DescribeAssociationExecutionTargetsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeAssociationExecutionTargetsResponse.ReadOnly
            ] = proxy(DescribeAssociationExecutionTargetsPaginated, request)
            def createOpsItem(
                request: CreateOpsItemRequest
            ): IO[AwsError, zio.aws.ssm.model.CreateOpsItemResponse.ReadOnly] =
              proxy(CreateOpsItem, request)
            def listCommands(
                request: ListCommandsRequest
            ): ZStream[Any, AwsError, zio.aws.ssm.model.Command.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListCommands, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listCommandsPaginated(
                request: ListCommandsRequest
            ): IO[AwsError, zio.aws.ssm.model.ListCommandsResponse.ReadOnly] =
              proxy(ListCommandsPaginated, request)
            def getAutomationExecution(
                request: GetAutomationExecutionRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.GetAutomationExecutionResponse.ReadOnly
            ] = proxy(GetAutomationExecution, request)
            def describeMaintenanceWindowExecutionTasks(
                request: DescribeMaintenanceWindowExecutionTasksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.MaintenanceWindowExecutionTaskIdentity.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeMaintenanceWindowExecutionTasks, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeMaintenanceWindowExecutionTasksPaginated(
                request: DescribeMaintenanceWindowExecutionTasksRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse.ReadOnly
            ] = proxy(DescribeMaintenanceWindowExecutionTasksPaginated, request)
            def listDocumentVersions(
                request: ListDocumentVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.DocumentVersionInfo.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDocumentVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDocumentVersionsPaginated(
                request: ListDocumentVersionsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.ListDocumentVersionsResponse.ReadOnly
            ] = proxy(ListDocumentVersionsPaginated, request)
            def getOpsSummary(
                request: GetOpsSummaryRequest
            ): ZStream[Any, AwsError, zio.aws.ssm.model.OpsEntity.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(GetOpsSummary, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def getOpsSummaryPaginated(
                request: GetOpsSummaryRequest
            ): IO[AwsError, zio.aws.ssm.model.GetOpsSummaryResponse.ReadOnly] =
              proxy(GetOpsSummaryPaginated, request)
            def describeDocument(request: DescribeDocumentRequest): IO[
              AwsError,
              zio.aws.ssm.model.DescribeDocumentResponse.ReadOnly
            ] = proxy(DescribeDocument, request)
            def describePatchGroups(
                request: DescribePatchGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.PatchGroupPatchBaselineMapping.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribePatchGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def describePatchGroupsPaginated(
                request: DescribePatchGroupsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribePatchGroupsResponse.ReadOnly
            ] = proxy(DescribePatchGroupsPaginated, request)
            def startAssociationsOnce(
                request: StartAssociationsOnceRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.StartAssociationsOnceResponse.ReadOnly
            ] = proxy(StartAssociationsOnce, request)
            def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
              AwsError,
              zio.aws.ssm.model.DeleteResourcePolicyResponse.ReadOnly
            ] = proxy(DeleteResourcePolicy, request)
            def describeMaintenanceWindowTargets(
                request: DescribeMaintenanceWindowTargetsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeMaintenanceWindowTargets, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeMaintenanceWindowTargetsPaginated(
                request: DescribeMaintenanceWindowTargetsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeMaintenanceWindowTargetsResponse.ReadOnly
            ] = proxy(DescribeMaintenanceWindowTargetsPaginated, request)
            def updateManagedInstanceRole(
                request: UpdateManagedInstanceRoleRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.UpdateManagedInstanceRoleResponse.ReadOnly
            ] = proxy(UpdateManagedInstanceRole, request)
            def describeInstanceInformation(
                request: DescribeInstanceInformationRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.InstanceInformation.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeInstanceInformation, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeInstanceInformationPaginated(
                request: DescribeInstanceInformationRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeInstanceInformationResponse.ReadOnly
            ] = proxy(DescribeInstanceInformationPaginated, request)
            def updateMaintenanceWindowTask(
                request: UpdateMaintenanceWindowTaskRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.UpdateMaintenanceWindowTaskResponse.ReadOnly
            ] = proxy(UpdateMaintenanceWindowTask, request)
            def describeMaintenanceWindows(
                request: DescribeMaintenanceWindowsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.MaintenanceWindowIdentity.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeMaintenanceWindows, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeMaintenanceWindowsPaginated(
                request: DescribeMaintenanceWindowsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeMaintenanceWindowsResponse.ReadOnly
            ] = proxy(DescribeMaintenanceWindowsPaginated, request)
            def getServiceSetting(request: GetServiceSettingRequest): IO[
              AwsError,
              zio.aws.ssm.model.GetServiceSettingResponse.ReadOnly
            ] = proxy(GetServiceSetting, request)
            def deleteOpsItem(
                request: DeleteOpsItemRequest
            ): IO[AwsError, zio.aws.ssm.model.DeleteOpsItemResponse.ReadOnly] =
              proxy(DeleteOpsItem, request)
            def registerDefaultPatchBaseline(
                request: RegisterDefaultPatchBaselineRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.RegisterDefaultPatchBaselineResponse.ReadOnly
            ] = proxy(RegisterDefaultPatchBaseline, request)
            def listDocumentMetadataHistory(
                request: ListDocumentMetadataHistoryRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.ListDocumentMetadataHistoryResponse.ReadOnly
            ] = proxy(ListDocumentMetadataHistory, request)
            def getParametersByPath(
                request: GetParametersByPathRequest
            ): ZStream[Any, AwsError, zio.aws.ssm.model.Parameter.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(GetParametersByPath, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def getParametersByPathPaginated(
                request: GetParametersByPathRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.GetParametersByPathResponse.ReadOnly
            ] = proxy(GetParametersByPathPaginated, request)
            def cancelMaintenanceWindowExecution(
                request: CancelMaintenanceWindowExecutionRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.CancelMaintenanceWindowExecutionResponse.ReadOnly
            ] = proxy(CancelMaintenanceWindowExecution, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.ssm.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def describeMaintenanceWindowExecutionTaskInvocations(
                request: DescribeMaintenanceWindowExecutionTaskInvocationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(
                    DescribeMaintenanceWindowExecutionTaskInvocations,
                    request
                  )
                }
                .getOrThrowFiberFailure()
            }
            def describeMaintenanceWindowExecutionTaskInvocationsPaginated(
                request: DescribeMaintenanceWindowExecutionTaskInvocationsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse.ReadOnly
            ] = proxy(
              DescribeMaintenanceWindowExecutionTaskInvocationsPaginated,
              request
            )
            def updateAssociation(request: UpdateAssociationRequest): IO[
              AwsError,
              zio.aws.ssm.model.UpdateAssociationResponse.ReadOnly
            ] = proxy(UpdateAssociation, request)
            def startSession(
                request: StartSessionRequest
            ): IO[AwsError, zio.aws.ssm.model.StartSessionResponse.ReadOnly] =
              proxy(StartSession, request)
            def associateOpsItemRelatedItem(
                request: AssociateOpsItemRelatedItemRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.AssociateOpsItemRelatedItemResponse.ReadOnly
            ] = proxy(AssociateOpsItemRelatedItem, request)
            def disassociateOpsItemRelatedItem(
                request: DisassociateOpsItemRelatedItemRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DisassociateOpsItemRelatedItemResponse.ReadOnly
            ] = proxy(DisassociateOpsItemRelatedItem, request)
            def describeOpsItems(request: DescribeOpsItemsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.OpsItemSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeOpsItems, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeOpsItemsPaginated(request: DescribeOpsItemsRequest): IO[
              AwsError,
              zio.aws.ssm.model.DescribeOpsItemsResponse.ReadOnly
            ] = proxy(DescribeOpsItemsPaginated, request)
            def describeEffectiveInstanceAssociations(
                request: DescribeEffectiveInstanceAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.InstanceAssociation.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeEffectiveInstanceAssociations, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeEffectiveInstanceAssociationsPaginated(
                request: DescribeEffectiveInstanceAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeEffectiveInstanceAssociationsResponse.ReadOnly
            ] = proxy(DescribeEffectiveInstanceAssociationsPaginated, request)
            def listAssociationVersions(
                request: ListAssociationVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.AssociationVersionInfo.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAssociationVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAssociationVersionsPaginated(
                request: ListAssociationVersionsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.ListAssociationVersionsResponse.ReadOnly
            ] = proxy(ListAssociationVersionsPaginated, request)
            def describeInstancePatches(
                request: DescribeInstancePatchesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.PatchComplianceData.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeInstancePatches, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeInstancePatchesPaginated(
                request: DescribeInstancePatchesRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeInstancePatchesResponse.ReadOnly
            ] = proxy(DescribeInstancePatchesPaginated, request)
            def getDeployablePatchSnapshotForInstance(
                request: GetDeployablePatchSnapshotForInstanceRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse.ReadOnly
            ] = proxy(GetDeployablePatchSnapshotForInstance, request)
            def putComplianceItems(request: PutComplianceItemsRequest): IO[
              AwsError,
              zio.aws.ssm.model.PutComplianceItemsResponse.ReadOnly
            ] = proxy(PutComplianceItems, request)
            def deleteActivation(request: DeleteActivationRequest): IO[
              AwsError,
              zio.aws.ssm.model.DeleteActivationResponse.ReadOnly
            ] = proxy(DeleteActivation, request)
            def listOpsItemRelatedItems(
                request: ListOpsItemRelatedItemsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.OpsItemRelatedItemSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListOpsItemRelatedItems, request)
                }
                .getOrThrowFiberFailure()
            }
            def listOpsItemRelatedItemsPaginated(
                request: ListOpsItemRelatedItemsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.ListOpsItemRelatedItemsResponse.ReadOnly
            ] = proxy(ListOpsItemRelatedItemsPaginated, request)
            def deleteParameter(request: DeleteParameterRequest): IO[
              AwsError,
              zio.aws.ssm.model.DeleteParameterResponse.ReadOnly
            ] = proxy(DeleteParameter, request)
            def describeInventoryDeletions(
                request: DescribeInventoryDeletionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.InventoryDeletionStatusItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeInventoryDeletions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeInventoryDeletionsPaginated(
                request: DescribeInventoryDeletionsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeInventoryDeletionsResponse.ReadOnly
            ] = proxy(DescribeInventoryDeletionsPaginated, request)
            def getCommandInvocation(request: GetCommandInvocationRequest): IO[
              AwsError,
              zio.aws.ssm.model.GetCommandInvocationResponse.ReadOnly
            ] = proxy(GetCommandInvocation, request)
            def updateAssociationStatus(
                request: UpdateAssociationStatusRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.UpdateAssociationStatusResponse.ReadOnly
            ] = proxy(UpdateAssociationStatus, request)
            def updateOpsMetadata(request: UpdateOpsMetadataRequest): IO[
              AwsError,
              zio.aws.ssm.model.UpdateOpsMetadataResponse.ReadOnly
            ] = proxy(UpdateOpsMetadata, request)
            def describePatchBaselines(
                request: DescribePatchBaselinesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribePatchBaselines, request)
                }
                .getOrThrowFiberFailure()
            }
            def describePatchBaselinesPaginated(
                request: DescribePatchBaselinesRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribePatchBaselinesResponse.ReadOnly
            ] = proxy(DescribePatchBaselinesPaginated, request)
            def describeEffectivePatchesForPatchBaseline(
                request: DescribeEffectivePatchesForPatchBaselineRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.EffectivePatch.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeEffectivePatchesForPatchBaseline, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeEffectivePatchesForPatchBaselinePaginated(
                request: DescribeEffectivePatchesForPatchBaselineRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse.ReadOnly
            ] =
              proxy(DescribeEffectivePatchesForPatchBaselinePaginated, request)
            def createActivation(request: CreateActivationRequest): IO[
              AwsError,
              zio.aws.ssm.model.CreateActivationResponse.ReadOnly
            ] = proxy(CreateActivation, request)
            def getMaintenanceWindowExecution(
                request: GetMaintenanceWindowExecutionRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.GetMaintenanceWindowExecutionResponse.ReadOnly
            ] = proxy(GetMaintenanceWindowExecution, request)
            def deregisterTaskFromMaintenanceWindow(
                request: DeregisterTaskFromMaintenanceWindowRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowResponse.ReadOnly
            ] = proxy(DeregisterTaskFromMaintenanceWindow, request)
            def deleteDocument(
                request: DeleteDocumentRequest
            ): IO[AwsError, zio.aws.ssm.model.DeleteDocumentResponse.ReadOnly] =
              proxy(DeleteDocument, request)
            def createResourceDataSync(
                request: CreateResourceDataSyncRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.CreateResourceDataSyncResponse.ReadOnly
            ] = proxy(CreateResourceDataSync, request)
            def getMaintenanceWindowExecutionTaskInvocation(
                request: GetMaintenanceWindowExecutionTaskInvocationRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse.ReadOnly
            ] = proxy(GetMaintenanceWindowExecutionTaskInvocation, request)
            def deregisterManagedInstance(
                request: DeregisterManagedInstanceRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DeregisterManagedInstanceResponse.ReadOnly
            ] = proxy(DeregisterManagedInstance, request)
            def updateOpsItem(
                request: UpdateOpsItemRequest
            ): IO[AwsError, zio.aws.ssm.model.UpdateOpsItemResponse.ReadOnly] =
              proxy(UpdateOpsItem, request)
            def deleteOpsMetadata(request: DeleteOpsMetadataRequest): IO[
              AwsError,
              zio.aws.ssm.model.DeleteOpsMetadataResponse.ReadOnly
            ] = proxy(DeleteOpsMetadata, request)
            def describeAvailablePatches(
                request: DescribeAvailablePatchesRequest
            ): ZStream[Any, AwsError, zio.aws.ssm.model.Patch.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeAvailablePatches, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeAvailablePatchesPaginated(
                request: DescribeAvailablePatchesRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeAvailablePatchesResponse.ReadOnly
            ] = proxy(DescribeAvailablePatchesPaginated, request)
            def listComplianceSummaries(
                request: ListComplianceSummariesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.ComplianceSummaryItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListComplianceSummaries, request)
                }
                .getOrThrowFiberFailure()
            }
            def listComplianceSummariesPaginated(
                request: ListComplianceSummariesRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.ListComplianceSummariesResponse.ReadOnly
            ] = proxy(ListComplianceSummariesPaginated, request)
            def deletePatchBaseline(request: DeletePatchBaselineRequest): IO[
              AwsError,
              zio.aws.ssm.model.DeletePatchBaselineResponse.ReadOnly
            ] = proxy(DeletePatchBaseline, request)
            def createOpsMetadata(request: CreateOpsMetadataRequest): IO[
              AwsError,
              zio.aws.ssm.model.CreateOpsMetadataResponse.ReadOnly
            ] = proxy(CreateOpsMetadata, request)
            def deregisterTargetFromMaintenanceWindow(
                request: DeregisterTargetFromMaintenanceWindowRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowResponse.ReadOnly
            ] = proxy(DeregisterTargetFromMaintenanceWindow, request)
            def putParameter(
                request: PutParameterRequest
            ): IO[AwsError, zio.aws.ssm.model.PutParameterResponse.ReadOnly] =
              proxy(PutParameter, request)
            def describeDocumentPermission(
                request: DescribeDocumentPermissionRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DescribeDocumentPermissionResponse.ReadOnly
            ] = proxy(DescribeDocumentPermission, request)
            def resetServiceSetting(request: ResetServiceSettingRequest): IO[
              AwsError,
              zio.aws.ssm.model.ResetServiceSettingResponse.ReadOnly
            ] = proxy(ResetServiceSetting, request)
            def updateResourceDataSync(
                request: UpdateResourceDataSyncRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.UpdateResourceDataSyncResponse.ReadOnly
            ] = proxy(UpdateResourceDataSync, request)
            def unlabelParameterVersion(
                request: UnlabelParameterVersionRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.UnlabelParameterVersionResponse.ReadOnly
            ] = proxy(UnlabelParameterVersion, request)
            def getInventorySchema(request: GetInventorySchemaRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.InventoryItemSchema.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetInventorySchema, request)
                }
                .getOrThrowFiberFailure()
            }
            def getInventorySchemaPaginated(
                request: GetInventorySchemaRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.GetInventorySchemaResponse.ReadOnly
            ] = proxy(GetInventorySchemaPaginated, request)
            def getCalendarState(request: GetCalendarStateRequest): IO[
              AwsError,
              zio.aws.ssm.model.GetCalendarStateResponse.ReadOnly
            ] = proxy(GetCalendarState, request)
            def listCommandInvocations(
                request: ListCommandInvocationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.CommandInvocation.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCommandInvocations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCommandInvocationsPaginated(
                request: ListCommandInvocationsRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.ListCommandInvocationsResponse.ReadOnly
            ] = proxy(ListCommandInvocationsPaginated, request)
            def deleteResourceDataSync(
                request: DeleteResourceDataSyncRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.DeleteResourceDataSyncResponse.ReadOnly
            ] = proxy(DeleteResourceDataSync, request)
            def getResourcePolicies(
                request: GetResourcePoliciesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssm.model.GetResourcePoliciesResponseEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetResourcePolicies, request)
                }
                .getOrThrowFiberFailure()
            }
            def getResourcePoliciesPaginated(
                request: GetResourcePoliciesRequest
            ): IO[
              AwsError,
              zio.aws.ssm.model.GetResourcePoliciesResponse.ReadOnly
            ] = proxy(GetResourcePoliciesPaginated, request)
            def updatePatchBaseline(request: UpdatePatchBaselineRequest): IO[
              AwsError,
              zio.aws.ssm.model.UpdatePatchBaselineResponse.ReadOnly
            ] = proxy(UpdatePatchBaseline, request)
          }
        }
      }
    }
  }
}
