package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetParametersByPathResponse(
    parameters: Optional[Iterable[zio.aws.ssm.model.Parameter]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse = {
    import GetParametersByPathResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetParametersByPathResponse.ReadOnly =
    zio.aws.ssm.model.GetParametersByPathResponse.wrap(buildAwsValue())
}
object GetParametersByPathResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetParametersByPathResponse =
      zio.aws.ssm.model.GetParametersByPathResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def parameters: Optional[List[zio.aws.ssm.model.Parameter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse
  ) extends zio.aws.ssm.model.GetParametersByPathResponse.ReadOnly {
    override val parameters
        : Optional[List[zio.aws.ssm.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Parameter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse
  ): zio.aws.ssm.model.GetParametersByPathResponse.ReadOnly = new Wrapper(impl)
}
