package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{AssociationId, InstanceId, DocumentARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteAssociationRequest(
    name: Optional[DocumentARN] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    associationId: Optional[AssociationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteAssociationRequest = {
    import DeleteAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteAssociationRequest
      .builder()
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteAssociationRequest.ReadOnly =
    zio.aws.ssm.model.DeleteAssociationRequest.wrap(buildAwsValue())
}
object DeleteAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteAssociationRequest =
      zio.aws.ssm.model.DeleteAssociationRequest(
        name.map(value => value),
        instanceId.map(value => value),
        associationId.map(value => value)
      )
    def name: Optional[DocumentARN]
    def instanceId: Optional[InstanceId]
    def associationId: Optional[AssociationId]
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteAssociationRequest
  ) extends zio.aws.ssm.model.DeleteAssociationRequest.ReadOnly {
    override val name: Optional[DocumentARN] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val associationId: Optional[AssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => zio.aws.ssm.model.primitives.AssociationId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteAssociationRequest
  ): zio.aws.ssm.model.DeleteAssociationRequest.ReadOnly = new Wrapper(impl)
}
