package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait ConnectionStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.ConnectionStatus
}
object ConnectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ConnectionStatus
  ): zio.aws.ssm.model.ConnectionStatus = value match {
    case software.amazon.awssdk.services.ssm.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ConnectionStatus.CONNECTED =>
      val r = connected
      r
    case software.amazon.awssdk.services.ssm.model.ConnectionStatus.NOTCONNECTED =>
      val r = notconnected
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ConnectionStatus =
      software.amazon.awssdk.services.ssm.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object connected extends zio.aws.ssm.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ConnectionStatus =
      software.amazon.awssdk.services.ssm.model.ConnectionStatus.CONNECTED
  }
  case object notconnected extends zio.aws.ssm.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ConnectionStatus =
      software.amazon.awssdk.services.ssm.model.ConnectionStatus.NOTCONNECTED
  }
}
