package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{MetadataKey, OpsMetadataArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateOpsMetadataRequest(
    opsMetadataArn: OpsMetadataArn,
    metadataToUpdate: Optional[
      Map[MetadataKey, zio.aws.ssm.model.MetadataValue]
    ] = Optional.Absent,
    keysToDelete: Optional[Iterable[MetadataKey]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataRequest = {
    import UpdateOpsMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataRequest
      .builder()
      .opsMetadataArn(OpsMetadataArn.unwrap(opsMetadataArn): java.lang.String)
      .optionallyWith(
        metadataToUpdate.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.metadataToUpdate)
      .optionallyWith(
        keysToDelete.map(value =>
          value.map { item =>
            MetadataKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.keysToDelete)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateOpsMetadataRequest.ReadOnly =
    zio.aws.ssm.model.UpdateOpsMetadataRequest.wrap(buildAwsValue())
}
object UpdateOpsMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateOpsMetadataRequest =
      zio.aws.ssm.model.UpdateOpsMetadataRequest(
        opsMetadataArn,
        metadataToUpdate.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        keysToDelete.map(value => value)
      )
    def opsMetadataArn: OpsMetadataArn
    def metadataToUpdate
        : Optional[Map[MetadataKey, zio.aws.ssm.model.MetadataValue.ReadOnly]]
    def keysToDelete: Optional[List[MetadataKey]]
    def getOpsMetadataArn: ZIO[Any, Nothing, OpsMetadataArn] =
      ZIO.succeed(opsMetadataArn)
    def getMetadataToUpdate: ZIO[Any, AwsError, Map[
      MetadataKey,
      zio.aws.ssm.model.MetadataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("metadataToUpdate", metadataToUpdate)
    def getKeysToDelete: ZIO[Any, AwsError, List[MetadataKey]] =
      AwsError.unwrapOptionField("keysToDelete", keysToDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataRequest
  ) extends zio.aws.ssm.model.UpdateOpsMetadataRequest.ReadOnly {
    override val opsMetadataArn: OpsMetadataArn =
      zio.aws.ssm.model.primitives.OpsMetadataArn(impl.opsMetadataArn())
    override val metadataToUpdate
        : Optional[Map[MetadataKey, zio.aws.ssm.model.MetadataValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataToUpdate())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .MetadataKey(key) -> zio.aws.ssm.model.MetadataValue.wrap(value)
            })
            .toMap
        )
    override val keysToDelete: Optional[List[MetadataKey]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keysToDelete())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.MetadataKey(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataRequest
  ): zio.aws.ssm.model.UpdateOpsMetadataRequest.ReadOnly = new Wrapper(impl)
}
