package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  SessionTarget,
  SessionDetails,
  MaxSessionDuration,
  DocumentName,
  SessionReason,
  DateTime,
  SessionOwner,
  SessionId
}
import scala.jdk.CollectionConverters.*
final case class Session(
    sessionId: Optional[SessionId] = Optional.Absent,
    target: Optional[SessionTarget] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.SessionStatus] = Optional.Absent,
    startDate: Optional[DateTime] = Optional.Absent,
    endDate: Optional[DateTime] = Optional.Absent,
    documentName: Optional[DocumentName] = Optional.Absent,
    owner: Optional[SessionOwner] = Optional.Absent,
    reason: Optional[SessionReason] = Optional.Absent,
    details: Optional[SessionDetails] = Optional.Absent,
    outputUrl: Optional[zio.aws.ssm.model.SessionManagerOutputUrl] =
      Optional.Absent,
    maxSessionDuration: Optional[MaxSessionDuration] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Session = {
    import Session.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Session
      .builder()
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        target.map(value => SessionTarget.unwrap(value): java.lang.String)
      )(_.target)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startDate.map(value => DateTime.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(endDate.map(value => DateTime.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(
        documentName.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.documentName)
      .optionallyWith(
        owner.map(value => SessionOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        reason.map(value => SessionReason.unwrap(value): java.lang.String)
      )(_.reason)
      .optionallyWith(
        details.map(value => SessionDetails.unwrap(value): java.lang.String)
      )(_.details)
      .optionallyWith(outputUrl.map(value => value.buildAwsValue()))(
        _.outputUrl
      )
      .optionallyWith(
        maxSessionDuration.map(value =>
          MaxSessionDuration.unwrap(value): java.lang.String
        )
      )(_.maxSessionDuration)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Session.ReadOnly =
    zio.aws.ssm.model.Session.wrap(buildAwsValue())
}
object Session {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Session] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Session = zio.aws.ssm.model.Session(
      sessionId.map(value => value),
      target.map(value => value),
      status.map(value => value),
      startDate.map(value => value),
      endDate.map(value => value),
      documentName.map(value => value),
      owner.map(value => value),
      reason.map(value => value),
      details.map(value => value),
      outputUrl.map(value => value.asEditable),
      maxSessionDuration.map(value => value)
    )
    def sessionId: Optional[SessionId]
    def target: Optional[SessionTarget]
    def status: Optional[zio.aws.ssm.model.SessionStatus]
    def startDate: Optional[DateTime]
    def endDate: Optional[DateTime]
    def documentName: Optional[DocumentName]
    def owner: Optional[SessionOwner]
    def reason: Optional[SessionReason]
    def details: Optional[SessionDetails]
    def outputUrl: Optional[zio.aws.ssm.model.SessionManagerOutputUrl.ReadOnly]
    def maxSessionDuration: Optional[MaxSessionDuration]
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getTarget: ZIO[Any, AwsError, SessionTarget] =
      AwsError.unwrapOptionField("target", target)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.SessionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStartDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getDocumentName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("documentName", documentName)
    def getOwner: ZIO[Any, AwsError, SessionOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getReason: ZIO[Any, AwsError, SessionReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getDetails: ZIO[Any, AwsError, SessionDetails] =
      AwsError.unwrapOptionField("details", details)
    def getOutputUrl: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.SessionManagerOutputUrl.ReadOnly
    ] = AwsError.unwrapOptionField("outputUrl", outputUrl)
    def getMaxSessionDuration: ZIO[Any, AwsError, MaxSessionDuration] =
      AwsError.unwrapOptionField("maxSessionDuration", maxSessionDuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Session
  ) extends zio.aws.ssm.model.Session.ReadOnly {
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.ssm.model.primitives.SessionId(value))
    override val target: Optional[SessionTarget] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value => zio.aws.ssm.model.primitives.SessionTarget(value))
    override val status: Optional[zio.aws.ssm.model.SessionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.SessionStatus.wrap(value))
    override val startDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val endDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val documentName: Optional[DocumentName] = zio.aws.core.internal
      .optionalFromNullable(impl.documentName())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val owner: Optional[SessionOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.ssm.model.primitives.SessionOwner(value))
    override val reason: Optional[SessionReason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.ssm.model.primitives.SessionReason(value))
    override val details: Optional[SessionDetails] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value => zio.aws.ssm.model.primitives.SessionDetails(value))
    override val outputUrl
        : Optional[zio.aws.ssm.model.SessionManagerOutputUrl.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputUrl())
        .map(value => zio.aws.ssm.model.SessionManagerOutputUrl.wrap(value))
    override val maxSessionDuration: Optional[MaxSessionDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSessionDuration())
        .map(value => zio.aws.ssm.model.primitives.MaxSessionDuration(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Session
  ): zio.aws.ssm.model.Session.ReadOnly = new Wrapper(impl)
}
