package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.ssm.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ResourceType
  ): zio.aws.ssm.model.ResourceType = value match {
    case software.amazon.awssdk.services.ssm.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ResourceType.MANAGED_INSTANCE =>
      val r = ManagedInstance
      r
    case software.amazon.awssdk.services.ssm.model.ResourceType.EC2_INSTANCE =>
      val r = EC2Instance
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceType =
      software.amazon.awssdk.services.ssm.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ManagedInstance extends zio.aws.ssm.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceType =
      software.amazon.awssdk.services.ssm.model.ResourceType.MANAGED_INSTANCE
  }
  case object EC2Instance extends zio.aws.ssm.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ResourceType =
      software.amazon.awssdk.services.ssm.model.ResourceType.EC2_INSTANCE
  }
}
