package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OpsItemNotification(arn: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsItemNotification = {
    import OpsItemNotification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItemNotification
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItemNotification.ReadOnly =
    zio.aws.ssm.model.OpsItemNotification.wrap(buildAwsValue())
}
object OpsItemNotification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.OpsItemNotification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItemNotification =
      zio.aws.ssm.model.OpsItemNotification(arn.map(value => value))
    def arn: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemNotification
  ) extends zio.aws.ssm.model.OpsItemNotification.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemNotification
  ): zio.aws.ssm.model.OpsItemNotification.ReadOnly = new Wrapper(impl)
}
