package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{PolicyHash, PolicyId, ResourceArnString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteResourcePolicyRequest(
    resourceArn: ResourceArnString,
    policyId: PolicyId,
    policyHash: PolicyHash
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteResourcePolicyRequest = {
    import DeleteResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteResourcePolicyRequest
      .builder()
      .resourceArn(ResourceArnString.unwrap(resourceArn): java.lang.String)
      .policyId(PolicyId.unwrap(policyId): java.lang.String)
      .policyHash(PolicyHash.unwrap(policyHash): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteResourcePolicyRequest.ReadOnly =
    zio.aws.ssm.model.DeleteResourcePolicyRequest.wrap(buildAwsValue())
}
object DeleteResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteResourcePolicyRequest =
      zio.aws.ssm.model
        .DeleteResourcePolicyRequest(resourceArn, policyId, policyHash)
    def resourceArn: ResourceArnString
    def policyId: PolicyId
    def policyHash: PolicyHash
    def getResourceArn: ZIO[Any, Nothing, ResourceArnString] =
      ZIO.succeed(resourceArn)
    def getPolicyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyId)
    def getPolicyHash: ZIO[Any, Nothing, PolicyHash] = ZIO.succeed(policyHash)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteResourcePolicyRequest
  ) extends zio.aws.ssm.model.DeleteResourcePolicyRequest.ReadOnly {
    override val resourceArn: ResourceArnString =
      zio.aws.ssm.model.primitives.ResourceArnString(impl.resourceArn())
    override val policyId: PolicyId =
      zio.aws.ssm.model.primitives.PolicyId(impl.policyId())
    override val policyHash: PolicyHash =
      zio.aws.ssm.model.primitives.PolicyHash(impl.policyHash())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteResourcePolicyRequest
  ): zio.aws.ssm.model.DeleteResourcePolicyRequest.ReadOnly = new Wrapper(impl)
}
