package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  DocumentHash,
  Comment,
  ParameterName,
  ParameterValue,
  TimeoutSeconds,
  DocumentVersion,
  S3KeyPrefix,
  S3BucketName,
  ServiceRole
}
import scala.jdk.CollectionConverters.*
final case class MaintenanceWindowRunCommandParameters(
    comment: Optional[Comment] = Optional.Absent,
    cloudWatchOutputConfig: Optional[zio.aws.ssm.model.CloudWatchOutputConfig] =
      Optional.Absent,
    documentHash: Optional[DocumentHash] = Optional.Absent,
    documentHashType: Optional[zio.aws.ssm.model.DocumentHashType] =
      Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    notificationConfig: Optional[zio.aws.ssm.model.NotificationConfig] =
      Optional.Absent,
    outputS3BucketName: Optional[S3BucketName] = Optional.Absent,
    outputS3KeyPrefix: Optional[S3KeyPrefix] = Optional.Absent,
    parameters: Optional[Map[ParameterName, Iterable[ParameterValue]]] =
      Optional.Absent,
    serviceRoleArn: Optional[ServiceRole] = Optional.Absent,
    timeoutSeconds: Optional[TimeoutSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowRunCommandParameters = {
    import MaintenanceWindowRunCommandParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowRunCommandParameters
      .builder()
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        cloudWatchOutputConfig.map(value => value.buildAwsValue())
      )(_.cloudWatchOutputConfig)
      .optionallyWith(
        documentHash.map(value => DocumentHash.unwrap(value): java.lang.String)
      )(_.documentHash)
      .optionallyWith(documentHashType.map(value => value.unwrap))(
        _.documentHashType
      )
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(notificationConfig.map(value => value.buildAwsValue()))(
        _.notificationConfig
      )
      .optionallyWith(
        outputS3BucketName.map(value =>
          S3BucketName.unwrap(value): java.lang.String
        )
      )(_.outputS3BucketName)
      .optionallyWith(
        outputS3KeyPrefix.map(value =>
          S3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.outputS3KeyPrefix)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> value.map {
                item =>
                  ParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        serviceRoleArn.map(value => ServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRoleArn)
      .optionallyWith(
        timeoutSeconds.map(value => TimeoutSeconds.unwrap(value): Integer)
      )(_.timeoutSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.MaintenanceWindowRunCommandParameters.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowRunCommandParameters
      .wrap(buildAwsValue())
}
object MaintenanceWindowRunCommandParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowRunCommandParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MaintenanceWindowRunCommandParameters =
      zio.aws.ssm.model.MaintenanceWindowRunCommandParameters(
        comment.map(value => value),
        cloudWatchOutputConfig.map(value => value.asEditable),
        documentHash.map(value => value),
        documentHashType.map(value => value),
        documentVersion.map(value => value),
        notificationConfig.map(value => value.asEditable),
        outputS3BucketName.map(value => value),
        outputS3KeyPrefix.map(value => value),
        parameters.map(value => value),
        serviceRoleArn.map(value => value),
        timeoutSeconds.map(value => value)
      )
    def comment: Optional[Comment]
    def cloudWatchOutputConfig
        : Optional[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly]
    def documentHash: Optional[DocumentHash]
    def documentHashType: Optional[zio.aws.ssm.model.DocumentHashType]
    def documentVersion: Optional[DocumentVersion]
    def notificationConfig
        : Optional[zio.aws.ssm.model.NotificationConfig.ReadOnly]
    def outputS3BucketName: Optional[S3BucketName]
    def outputS3KeyPrefix: Optional[S3KeyPrefix]
    def parameters: Optional[Map[ParameterName, List[ParameterValue]]]
    def serviceRoleArn: Optional[ServiceRole]
    def timeoutSeconds: Optional[TimeoutSeconds]
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getCloudWatchOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchOutputConfig",
      cloudWatchOutputConfig
    )
    def getDocumentHash: ZIO[Any, AwsError, DocumentHash] =
      AwsError.unwrapOptionField("documentHash", documentHash)
    def getDocumentHashType
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentHashType] =
      AwsError.unwrapOptionField("documentHashType", documentHashType)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getNotificationConfig
        : ZIO[Any, AwsError, zio.aws.ssm.model.NotificationConfig.ReadOnly] =
      AwsError.unwrapOptionField("notificationConfig", notificationConfig)
    def getOutputS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("outputS3BucketName", outputS3BucketName)
    def getOutputS3KeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("outputS3KeyPrefix", outputS3KeyPrefix)
    def getParameters
        : ZIO[Any, AwsError, Map[ParameterName, List[ParameterValue]]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getServiceRoleArn: ZIO[Any, AwsError, ServiceRole] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getTimeoutSeconds: ZIO[Any, AwsError, TimeoutSeconds] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowRunCommandParameters
  ) extends zio.aws.ssm.model.MaintenanceWindowRunCommandParameters.ReadOnly {
    override val comment: Optional[Comment] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.ssm.model.primitives.Comment(value))
    override val cloudWatchOutputConfig
        : Optional[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchOutputConfig())
        .map(value => zio.aws.ssm.model.CloudWatchOutputConfig.wrap(value))
    override val documentHash: Optional[DocumentHash] = zio.aws.core.internal
      .optionalFromNullable(impl.documentHash())
      .map(value => zio.aws.ssm.model.primitives.DocumentHash(value))
    override val documentHashType
        : Optional[zio.aws.ssm.model.DocumentHashType] = zio.aws.core.internal
      .optionalFromNullable(impl.documentHashType())
      .map(value => zio.aws.ssm.model.DocumentHashType.wrap(value))
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val notificationConfig
        : Optional[zio.aws.ssm.model.NotificationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationConfig())
        .map(value => zio.aws.ssm.model.NotificationConfig.wrap(value))
    override val outputS3BucketName: Optional[S3BucketName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputS3BucketName())
        .map(value => zio.aws.ssm.model.primitives.S3BucketName(value))
    override val outputS3KeyPrefix: Optional[S3KeyPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputS3KeyPrefix())
        .map(value => zio.aws.ssm.model.primitives.S3KeyPrefix(value))
    override val parameters
        : Optional[Map[ParameterName, List[ParameterValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .ParameterName(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.ParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val serviceRoleArn: Optional[ServiceRole] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRoleArn())
      .map(value => zio.aws.ssm.model.primitives.ServiceRole(value))
    override val timeoutSeconds: Optional[TimeoutSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutSeconds())
        .map(value => zio.aws.ssm.model.primitives.TimeoutSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowRunCommandParameters
  ): zio.aws.ssm.model.MaintenanceWindowRunCommandParameters.ReadOnly =
    new Wrapper(impl)
}
