package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{NextToken, MaxResults, DocumentARN}
import scala.jdk.CollectionConverters.*
final case class ListDocumentVersionsRequest(
    name: DocumentARN,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest = {
    import ListDocumentVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest
      .builder()
      .name(DocumentARN.unwrap(name): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListDocumentVersionsRequest.ReadOnly =
    zio.aws.ssm.model.ListDocumentVersionsRequest.wrap(buildAwsValue())
}
object ListDocumentVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListDocumentVersionsRequest =
      zio.aws.ssm.model.ListDocumentVersionsRequest(
        name,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def name: DocumentARN
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getName: ZIO[Any, Nothing, DocumentARN] = ZIO.succeed(name)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest
  ) extends zio.aws.ssm.model.ListDocumentVersionsRequest.ReadOnly {
    override val name: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.name())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest
  ): zio.aws.ssm.model.ListDocumentVersionsRequest.ReadOnly = new Wrapper(impl)
}
