package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetParameterResponse(
    parameter: Optional[zio.aws.ssm.model.Parameter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetParameterResponse = {
    import GetParameterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetParameterResponse
      .builder()
      .optionallyWith(parameter.map(value => value.buildAwsValue()))(
        _.parameter
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetParameterResponse.ReadOnly =
    zio.aws.ssm.model.GetParameterResponse.wrap(buildAwsValue())
}
object GetParameterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetParameterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetParameterResponse = zio.aws.ssm.model
      .GetParameterResponse(parameter.map(value => value.asEditable))
    def parameter: Optional[zio.aws.ssm.model.Parameter.ReadOnly]
    def getParameter: ZIO[Any, AwsError, zio.aws.ssm.model.Parameter.ReadOnly] =
      AwsError.unwrapOptionField("parameter", parameter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetParameterResponse
  ) extends zio.aws.ssm.model.GetParameterResponse.ReadOnly {
    override val parameter: Optional[zio.aws.ssm.model.Parameter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameter())
        .map(value => zio.aws.ssm.model.Parameter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetParameterResponse
  ): zio.aws.ssm.model.GetParameterResponse.ReadOnly = new Wrapper(impl)
}
