package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  OpsItemAccountId,
  DateTime,
  OpsItemType,
  OpsItemPriority,
  OpsItemSource,
  OpsItemSeverity,
  OpsItemDataKey,
  OpsItemDescription,
  OpsItemTitle,
  OpsItemCategory
}
import scala.jdk.CollectionConverters.*
final case class CreateOpsItemRequest(
    description: OpsItemDescription,
    opsItemType: Optional[OpsItemType] = Optional.Absent,
    operationalData: Optional[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue]
    ] = Optional.Absent,
    notifications: Optional[Iterable[zio.aws.ssm.model.OpsItemNotification]] =
      Optional.Absent,
    priority: Optional[OpsItemPriority] = Optional.Absent,
    relatedOpsItems: Optional[Iterable[zio.aws.ssm.model.RelatedOpsItem]] =
      Optional.Absent,
    source: OpsItemSource,
    title: OpsItemTitle,
    tags: Optional[Iterable[zio.aws.ssm.model.Tag]] = Optional.Absent,
    category: Optional[OpsItemCategory] = Optional.Absent,
    severity: Optional[OpsItemSeverity] = Optional.Absent,
    actualStartTime: Optional[DateTime] = Optional.Absent,
    actualEndTime: Optional[DateTime] = Optional.Absent,
    plannedStartTime: Optional[DateTime] = Optional.Absent,
    plannedEndTime: Optional[DateTime] = Optional.Absent,
    accountId: Optional[OpsItemAccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest = {
    import CreateOpsItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest
      .builder()
      .description(OpsItemDescription.unwrap(description): java.lang.String)
      .optionallyWith(
        opsItemType.map(value => OpsItemType.unwrap(value): java.lang.String)
      )(_.opsItemType)
      .optionallyWith(
        operationalData.map(value =>
          value
            .map({ case (key, value) =>
              (OpsItemDataKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.operationalData)
      .optionallyWith(
        notifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notifications)
      .optionallyWith(
        priority.map(value => OpsItemPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        relatedOpsItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedOpsItems)
      .source(OpsItemSource.unwrap(source): java.lang.String)
      .title(OpsItemTitle.unwrap(title): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        category.map(value => OpsItemCategory.unwrap(value): java.lang.String)
      )(_.category)
      .optionallyWith(
        severity.map(value => OpsItemSeverity.unwrap(value): java.lang.String)
      )(_.severity)
      .optionallyWith(
        actualStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualStartTime)
      .optionallyWith(
        actualEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualEndTime)
      .optionallyWith(
        plannedStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedStartTime)
      .optionallyWith(
        plannedEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedEndTime)
      .optionallyWith(
        accountId.map(value => OpsItemAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateOpsItemRequest.ReadOnly =
    zio.aws.ssm.model.CreateOpsItemRequest.wrap(buildAwsValue())
}
object CreateOpsItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateOpsItemRequest =
      zio.aws.ssm.model.CreateOpsItemRequest(
        description,
        opsItemType.map(value => value),
        operationalData.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        notifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        priority.map(value => value),
        relatedOpsItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        source,
        title,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        category.map(value => value),
        severity.map(value => value),
        actualStartTime.map(value => value),
        actualEndTime.map(value => value),
        plannedStartTime.map(value => value),
        plannedEndTime.map(value => value),
        accountId.map(value => value)
      )
    def description: OpsItemDescription
    def opsItemType: Optional[OpsItemType]
    def operationalData: Optional[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ]
    def notifications
        : Optional[List[zio.aws.ssm.model.OpsItemNotification.ReadOnly]]
    def priority: Optional[OpsItemPriority]
    def relatedOpsItems
        : Optional[List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]]
    def source: OpsItemSource
    def title: OpsItemTitle
    def tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def category: Optional[OpsItemCategory]
    def severity: Optional[OpsItemSeverity]
    def actualStartTime: Optional[DateTime]
    def actualEndTime: Optional[DateTime]
    def plannedStartTime: Optional[DateTime]
    def plannedEndTime: Optional[DateTime]
    def accountId: Optional[OpsItemAccountId]
    def getDescription: ZIO[Any, Nothing, OpsItemDescription] =
      ZIO.succeed(description)
    def getOpsItemType: ZIO[Any, AwsError, OpsItemType] =
      AwsError.unwrapOptionField("opsItemType", opsItemType)
    def getOperationalData: ZIO[Any, AwsError, Map[
      OpsItemDataKey,
      zio.aws.ssm.model.OpsItemDataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("operationalData", operationalData)
    def getNotifications: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsItemNotification.ReadOnly
    ]] = AwsError.unwrapOptionField("notifications", notifications)
    def getPriority: ZIO[Any, AwsError, OpsItemPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getRelatedOpsItems
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]] =
      AwsError.unwrapOptionField("relatedOpsItems", relatedOpsItems)
    def getSource: ZIO[Any, Nothing, OpsItemSource] = ZIO.succeed(source)
    def getTitle: ZIO[Any, Nothing, OpsItemTitle] = ZIO.succeed(title)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCategory: ZIO[Any, AwsError, OpsItemCategory] =
      AwsError.unwrapOptionField("category", category)
    def getSeverity: ZIO[Any, AwsError, OpsItemSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getActualStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualStartTime", actualStartTime)
    def getActualEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualEndTime", actualEndTime)
    def getPlannedStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedStartTime", plannedStartTime)
    def getPlannedEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedEndTime", plannedEndTime)
    def getAccountId: ZIO[Any, AwsError, OpsItemAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest
  ) extends zio.aws.ssm.model.CreateOpsItemRequest.ReadOnly {
    override val description: OpsItemDescription =
      zio.aws.ssm.model.primitives.OpsItemDescription(impl.description())
    override val opsItemType: Optional[OpsItemType] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemType())
      .map(value => zio.aws.ssm.model.primitives.OpsItemType(value))
    override val operationalData: Optional[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.operationalData())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.OpsItemDataKey(
              key
            ) -> zio.aws.ssm.model.OpsItemDataValue.wrap(value)
          })
          .toMap
      )
    override val notifications
        : Optional[List[zio.aws.ssm.model.OpsItemNotification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsItemNotification.wrap(item)
          }.toList
        )
    override val priority: Optional[OpsItemPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.ssm.model.primitives.OpsItemPriority(value))
    override val relatedOpsItems
        : Optional[List[zio.aws.ssm.model.RelatedOpsItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedOpsItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.RelatedOpsItem.wrap(item)
          }.toList
        )
    override val source: OpsItemSource =
      zio.aws.ssm.model.primitives.OpsItemSource(impl.source())
    override val title: OpsItemTitle =
      zio.aws.ssm.model.primitives.OpsItemTitle(impl.title())
    override val tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Tag.wrap(item)
          }.toList
        )
    override val category: Optional[OpsItemCategory] = zio.aws.core.internal
      .optionalFromNullable(impl.category())
      .map(value => zio.aws.ssm.model.primitives.OpsItemCategory(value))
    override val severity: Optional[OpsItemSeverity] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => zio.aws.ssm.model.primitives.OpsItemSeverity(value))
    override val actualStartTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.actualStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val actualEndTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.actualEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedStartTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.plannedStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedEndTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.plannedEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val accountId: Optional[OpsItemAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.ssm.model.primitives.OpsItemAccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest
  ): zio.aws.ssm.model.CreateOpsItemRequest.ReadOnly = new Wrapper(impl)
}
