package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  NextToken,
  DocumentPermissionMaxResults,
  DocumentName
}
import scala.jdk.CollectionConverters.*
final case class DescribeDocumentPermissionRequest(
    name: DocumentName,
    permissionType: zio.aws.ssm.model.DocumentPermissionType,
    maxResults: Optional[DocumentPermissionMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionRequest = {
    import DescribeDocumentPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionRequest
      .builder()
      .name(DocumentName.unwrap(name): java.lang.String)
      .permissionType(permissionType.unwrap)
      .optionallyWith(
        maxResults.map(value =>
          DocumentPermissionMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeDocumentPermissionRequest.ReadOnly =
    zio.aws.ssm.model.DescribeDocumentPermissionRequest.wrap(buildAwsValue())
}
object DescribeDocumentPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeDocumentPermissionRequest =
      zio.aws.ssm.model.DescribeDocumentPermissionRequest(
        name,
        permissionType,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def name: DocumentName
    def permissionType: zio.aws.ssm.model.DocumentPermissionType
    def maxResults: Optional[DocumentPermissionMaxResults]
    def nextToken: Optional[NextToken]
    def getName: ZIO[Any, Nothing, DocumentName] = ZIO.succeed(name)
    def getPermissionType
        : ZIO[Any, Nothing, zio.aws.ssm.model.DocumentPermissionType] =
      ZIO.succeed(permissionType)
    def getMaxResults: ZIO[Any, AwsError, DocumentPermissionMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionRequest
  ) extends zio.aws.ssm.model.DescribeDocumentPermissionRequest.ReadOnly {
    override val name: DocumentName =
      zio.aws.ssm.model.primitives.DocumentName(impl.name())
    override val permissionType: zio.aws.ssm.model.DocumentPermissionType =
      zio.aws.ssm.model.DocumentPermissionType.wrap(impl.permissionType())
    override val maxResults: Optional[DocumentPermissionMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.DocumentPermissionMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionRequest
  ): zio.aws.ssm.model.DescribeDocumentPermissionRequest.ReadOnly = new Wrapper(
    impl
  )
}
