package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentDisplayName,
  DocumentName,
  DocumentVersion,
  DocumentContent,
  DocumentVersionName,
  TargetType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDocumentRequest(
    content: DocumentContent,
    attachments: Optional[Iterable[zio.aws.ssm.model.AttachmentsSource]] =
      Optional.Absent,
    name: DocumentName,
    displayName: Optional[DocumentDisplayName] = Optional.Absent,
    versionName: Optional[DocumentVersionName] = Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    documentFormat: Optional[zio.aws.ssm.model.DocumentFormat] =
      Optional.Absent,
    targetType: Optional[TargetType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest = {
    import UpdateDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest
      .builder()
      .content(DocumentContent.unwrap(content): java.lang.String)
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .name(DocumentName.unwrap(name): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          DocumentDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(documentFormat.map(value => value.unwrap))(
        _.documentFormat
      )
      .optionallyWith(
        targetType.map(value => TargetType.unwrap(value): java.lang.String)
      )(_.targetType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateDocumentRequest.ReadOnly =
    zio.aws.ssm.model.UpdateDocumentRequest.wrap(buildAwsValue())
}
object UpdateDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateDocumentRequest =
      zio.aws.ssm.model.UpdateDocumentRequest(
        content,
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name,
        displayName.map(value => value),
        versionName.map(value => value),
        documentVersion.map(value => value),
        documentFormat.map(value => value),
        targetType.map(value => value)
      )
    def content: DocumentContent
    def attachments
        : Optional[List[zio.aws.ssm.model.AttachmentsSource.ReadOnly]]
    def name: DocumentName
    def displayName: Optional[DocumentDisplayName]
    def versionName: Optional[DocumentVersionName]
    def documentVersion: Optional[DocumentVersion]
    def documentFormat: Optional[zio.aws.ssm.model.DocumentFormat]
    def targetType: Optional[TargetType]
    def getContent: ZIO[Any, Nothing, DocumentContent] = ZIO.succeed(content)
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AttachmentsSource.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
    def getName: ZIO[Any, Nothing, DocumentName] = ZIO.succeed(name)
    def getDisplayName: ZIO[Any, AwsError, DocumentDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getDocumentFormat
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentFormat] =
      AwsError.unwrapOptionField("documentFormat", documentFormat)
    def getTargetType: ZIO[Any, AwsError, TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest
  ) extends zio.aws.ssm.model.UpdateDocumentRequest.ReadOnly {
    override val content: DocumentContent =
      zio.aws.ssm.model.primitives.DocumentContent(impl.content())
    override val attachments
        : Optional[List[zio.aws.ssm.model.AttachmentsSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.AttachmentsSource.wrap(item)
          }.toList
        )
    override val name: DocumentName =
      zio.aws.ssm.model.primitives.DocumentName(impl.name())
    override val displayName: Optional[DocumentDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value => zio.aws.ssm.model.primitives.DocumentDisplayName(value))
    override val versionName: Optional[DocumentVersionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionName())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val documentFormat: Optional[zio.aws.ssm.model.DocumentFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentFormat())
        .map(value => zio.aws.ssm.model.DocumentFormat.wrap(value))
    override val targetType: Optional[TargetType] = zio.aws.core.internal
      .optionalFromNullable(impl.targetType())
      .map(value => zio.aws.ssm.model.primitives.TargetType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest
  ): zio.aws.ssm.model.UpdateDocumentRequest.ReadOnly = new Wrapper(impl)
}
