package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{OpsItemArn, OpsItemId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetOpsItemRequest(
    opsItemId: OpsItemId,
    opsItemArn: Optional[OpsItemArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetOpsItemRequest = {
    import GetOpsItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetOpsItemRequest
      .builder()
      .opsItemId(OpsItemId.unwrap(opsItemId): java.lang.String)
      .optionallyWith(
        opsItemArn.map(value => OpsItemArn.unwrap(value): java.lang.String)
      )(_.opsItemArn)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetOpsItemRequest.ReadOnly =
    zio.aws.ssm.model.GetOpsItemRequest.wrap(buildAwsValue())
}
object GetOpsItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetOpsItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetOpsItemRequest = zio.aws.ssm.model
      .GetOpsItemRequest(opsItemId, opsItemArn.map(value => value))
    def opsItemId: OpsItemId
    def opsItemArn: Optional[OpsItemArn]
    def getOpsItemId: ZIO[Any, Nothing, OpsItemId] = ZIO.succeed(opsItemId)
    def getOpsItemArn: ZIO[Any, AwsError, OpsItemArn] =
      AwsError.unwrapOptionField("opsItemArn", opsItemArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsItemRequest
  ) extends zio.aws.ssm.model.GetOpsItemRequest.ReadOnly {
    override val opsItemId: OpsItemId =
      zio.aws.ssm.model.primitives.OpsItemId(impl.opsItemId())
    override val opsItemArn: Optional[OpsItemArn] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemArn())
      .map(value => zio.aws.ssm.model.primitives.OpsItemArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsItemRequest
  ): zio.aws.ssm.model.GetOpsItemRequest.ReadOnly = new Wrapper(impl)
}
