package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters.*
final case class GetInventoryRequest(
    filters: Optional[Iterable[zio.aws.ssm.model.InventoryFilter]] =
      Optional.Absent,
    aggregators: Optional[Iterable[zio.aws.ssm.model.InventoryAggregator]] =
      Optional.Absent,
    resultAttributes: Optional[Iterable[zio.aws.ssm.model.ResultAttribute]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetInventoryRequest = {
    import GetInventoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetInventoryRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        aggregators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregators)
      .optionallyWith(
        resultAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resultAttributes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetInventoryRequest.ReadOnly =
    zio.aws.ssm.model.GetInventoryRequest.wrap(buildAwsValue())
}
object GetInventoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetInventoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetInventoryRequest =
      zio.aws.ssm.model.GetInventoryRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        aggregators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resultAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Optional[List[zio.aws.ssm.model.InventoryFilter.ReadOnly]]
    def aggregators
        : Optional[List[zio.aws.ssm.model.InventoryAggregator.ReadOnly]]
    def resultAttributes
        : Optional[List[zio.aws.ssm.model.ResultAttribute.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.InventoryFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getAggregators: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InventoryAggregator.ReadOnly
    ]] = AwsError.unwrapOptionField("aggregators", aggregators)
    def getResultAttributes
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.ResultAttribute.ReadOnly]] =
      AwsError.unwrapOptionField("resultAttributes", resultAttributes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetInventoryRequest
  ) extends zio.aws.ssm.model.GetInventoryRequest.ReadOnly {
    override val filters
        : Optional[List[zio.aws.ssm.model.InventoryFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InventoryFilter.wrap(item)
          }.toList
        )
    override val aggregators
        : Optional[List[zio.aws.ssm.model.InventoryAggregator.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.InventoryAggregator.wrap(item)
          }.toList
        )
    override val resultAttributes
        : Optional[List[zio.aws.ssm.model.ResultAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.ResultAttribute.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetInventoryRequest
  ): zio.aws.ssm.model.GetInventoryRequest.ReadOnly = new Wrapper(impl)
}
