package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait DocumentType {
  def unwrap: software.amazon.awssdk.services.ssm.model.DocumentType
}
object DocumentType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.DocumentType
  ): zio.aws.ssm.model.DocumentType = value match {
    case software.amazon.awssdk.services.ssm.model.DocumentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.COMMAND =>
      val r = Command
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.POLICY =>
      val r = Policy
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.AUTOMATION =>
      val r = Automation
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.SESSION =>
      val r = Session
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.PACKAGE =>
      val r = Package
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.APPLICATION_CONFIGURATION =>
      val r = ApplicationConfiguration
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.APPLICATION_CONFIGURATION_SCHEMA =>
      val r = ApplicationConfigurationSchema
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.DEPLOYMENT_STRATEGY =>
      val r = DeploymentStrategy
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.CHANGE_CALENDAR =>
      val r = ChangeCalendar
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.AUTOMATION_CHANGE_TEMPLATE =>
      val r = `Automation.ChangeTemplate`
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.PROBLEM_ANALYSIS =>
      val r = ProblemAnalysis
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.PROBLEM_ANALYSIS_TEMPLATE =>
      val r = ProblemAnalysisTemplate
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.CLOUD_FORMATION =>
      val r = CloudFormation
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.CONFORMANCE_PACK_TEMPLATE =>
      val r = ConformancePackTemplate
      r
    case software.amazon.awssdk.services.ssm.model.DocumentType.QUICK_SETUP =>
      val r = QuickSetup
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.UNKNOWN_TO_SDK_VERSION
  }
  case object Command extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.COMMAND
  }
  case object Policy extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.POLICY
  }
  case object Automation extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.AUTOMATION
  }
  case object Session extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.SESSION
  }
  case object Package extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.PACKAGE
  }
  case object ApplicationConfiguration extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.APPLICATION_CONFIGURATION
  }
  case object ApplicationConfigurationSchema
      extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.APPLICATION_CONFIGURATION_SCHEMA
  }
  case object DeploymentStrategy extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.DEPLOYMENT_STRATEGY
  }
  case object ChangeCalendar extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.CHANGE_CALENDAR
  }
  case object `Automation.ChangeTemplate`
      extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.AUTOMATION_CHANGE_TEMPLATE
  }
  case object ProblemAnalysis extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.PROBLEM_ANALYSIS
  }
  case object ProblemAnalysisTemplate extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.PROBLEM_ANALYSIS_TEMPLATE
  }
  case object CloudFormation extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.CLOUD_FORMATION
  }
  case object ConformancePackTemplate extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.CONFORMANCE_PACK_TEMPLATE
  }
  case object QuickSetup extends zio.aws.ssm.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentType =
      software.amazon.awssdk.services.ssm.model.DocumentType.QUICK_SETUP
  }
}
