package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  ParameterStringFilterValue,
  ParameterStringQueryOption,
  ParameterStringFilterKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ParameterStringFilter(
    key: ParameterStringFilterKey,
    option: Optional[ParameterStringQueryOption] = Optional.Absent,
    values: Optional[Iterable[ParameterStringFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ParameterStringFilter = {
    import ParameterStringFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ParameterStringFilter
      .builder()
      .key(ParameterStringFilterKey.unwrap(key): java.lang.String)
      .optionallyWith(
        option.map(value =>
          ParameterStringQueryOption.unwrap(value): java.lang.String
        )
      )(_.option)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            ParameterStringFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ParameterStringFilter.ReadOnly =
    zio.aws.ssm.model.ParameterStringFilter.wrap(buildAwsValue())
}
object ParameterStringFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ParameterStringFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ParameterStringFilter =
      zio.aws.ssm.model.ParameterStringFilter(
        key,
        option.map(value => value),
        values.map(value => value)
      )
    def key: ParameterStringFilterKey
    def option: Optional[ParameterStringQueryOption]
    def values: Optional[List[ParameterStringFilterValue]]
    def getKey: ZIO[Any, Nothing, ParameterStringFilterKey] = ZIO.succeed(key)
    def getOption: ZIO[Any, AwsError, ParameterStringQueryOption] =
      AwsError.unwrapOptionField("option", option)
    def getValues: ZIO[Any, AwsError, List[ParameterStringFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ParameterStringFilter
  ) extends zio.aws.ssm.model.ParameterStringFilter.ReadOnly {
    override val key: ParameterStringFilterKey =
      zio.aws.ssm.model.primitives.ParameterStringFilterKey(impl.key())
    override val option: Optional[ParameterStringQueryOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.option())
        .map(value =>
          zio.aws.ssm.model.primitives.ParameterStringQueryOption(value)
        )
    override val values: Optional[List[ParameterStringFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.ParameterStringFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ParameterStringFilter
  ): zio.aws.ssm.model.ParameterStringFilter.ReadOnly = new Wrapper(impl)
}
