package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeActivationsFilter(
    filterKey: Optional[zio.aws.ssm.model.DescribeActivationsFilterKeys] =
      Optional.Absent,
    filterValues: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeActivationsFilter = {
    import DescribeActivationsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeActivationsFilter
      .builder()
      .optionallyWith(filterKey.map(value => value.unwrap))(_.filterKey)
      .optionallyWith(
        filterValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.filterValues)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeActivationsFilter.ReadOnly =
    zio.aws.ssm.model.DescribeActivationsFilter.wrap(buildAwsValue())
}
object DescribeActivationsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeActivationsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeActivationsFilter =
      zio.aws.ssm.model.DescribeActivationsFilter(
        filterKey.map(value => value),
        filterValues.map(value => value)
      )
    def filterKey: Optional[zio.aws.ssm.model.DescribeActivationsFilterKeys]
    def filterValues: Optional[List[String]]
    def getFilterKey
        : ZIO[Any, AwsError, zio.aws.ssm.model.DescribeActivationsFilterKeys] =
      AwsError.unwrapOptionField("filterKey", filterKey)
    def getFilterValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("filterValues", filterValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeActivationsFilter
  ) extends zio.aws.ssm.model.DescribeActivationsFilter.ReadOnly {
    override val filterKey
        : Optional[zio.aws.ssm.model.DescribeActivationsFilterKeys] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterKey())
        .map(value =>
          zio.aws.ssm.model.DescribeActivationsFilterKeys.wrap(value)
        )
    override val filterValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.filterValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeActivationsFilter
  ): zio.aws.ssm.model.DescribeActivationsFilter.ReadOnly = new Wrapper(impl)
}
