package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait InventoryDeletionStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.InventoryDeletionStatus
}
object InventoryDeletionStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.InventoryDeletionStatus
  ): zio.aws.ssm.model.InventoryDeletionStatus = value match {
    case software.amazon.awssdk.services.ssm.model.InventoryDeletionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.InventoryDeletionStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.ssm.model.InventoryDeletionStatus.COMPLETE =>
      val r = Complete
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.InventoryDeletionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryDeletionStatus =
      software.amazon.awssdk.services.ssm.model.InventoryDeletionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.ssm.model.InventoryDeletionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryDeletionStatus =
      software.amazon.awssdk.services.ssm.model.InventoryDeletionStatus.IN_PROGRESS
  }
  case object Complete extends zio.aws.ssm.model.InventoryDeletionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.InventoryDeletionStatus =
      software.amazon.awssdk.services.ssm.model.InventoryDeletionStatus.COMPLETE
  }
}
