package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait PatchSet {
  def unwrap: software.amazon.awssdk.services.ssm.model.PatchSet
}
object PatchSet {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.PatchSet
  ): zio.aws.ssm.model.PatchSet = value match {
    case software.amazon.awssdk.services.ssm.model.PatchSet.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.PatchSet.OS =>
      val r = OS
      r
    case software.amazon.awssdk.services.ssm.model.PatchSet.APPLICATION =>
      val r = APPLICATION
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.PatchSet {
    override def unwrap: software.amazon.awssdk.services.ssm.model.PatchSet =
      software.amazon.awssdk.services.ssm.model.PatchSet.UNKNOWN_TO_SDK_VERSION
  }
  case object OS extends zio.aws.ssm.model.PatchSet {
    override def unwrap: software.amazon.awssdk.services.ssm.model.PatchSet =
      software.amazon.awssdk.services.ssm.model.PatchSet.OS
  }
  case object APPLICATION extends zio.aws.ssm.model.PatchSet {
    override def unwrap: software.amazon.awssdk.services.ssm.model.PatchSet =
      software.amazon.awssdk.services.ssm.model.PatchSet.APPLICATION
  }
}
