package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{DocumentVersion, DocumentName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDocumentMetadataRequest(
    name: DocumentName,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    documentReviews: zio.aws.ssm.model.DocumentReviews
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataRequest = {
    import UpdateDocumentMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataRequest
      .builder()
      .name(DocumentName.unwrap(name): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .documentReviews(documentReviews.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateDocumentMetadataRequest.ReadOnly =
    zio.aws.ssm.model.UpdateDocumentMetadataRequest.wrap(buildAwsValue())
}
object UpdateDocumentMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateDocumentMetadataRequest =
      zio.aws.ssm.model.UpdateDocumentMetadataRequest(
        name,
        documentVersion.map(value => value),
        documentReviews.asEditable
      )
    def name: DocumentName
    def documentVersion: Optional[DocumentVersion]
    def documentReviews: zio.aws.ssm.model.DocumentReviews.ReadOnly
    def getName: ZIO[Any, Nothing, DocumentName] = ZIO.succeed(name)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getDocumentReviews
        : ZIO[Any, Nothing, zio.aws.ssm.model.DocumentReviews.ReadOnly] =
      ZIO.succeed(documentReviews)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataRequest
  ) extends zio.aws.ssm.model.UpdateDocumentMetadataRequest.ReadOnly {
    override val name: DocumentName =
      zio.aws.ssm.model.primitives.DocumentName(impl.name())
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val documentReviews: zio.aws.ssm.model.DocumentReviews.ReadOnly =
      zio.aws.ssm.model.DocumentReviews.wrap(impl.documentReviews())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataRequest
  ): zio.aws.ssm.model.UpdateDocumentMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
