package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.OpsItemMaxResults
import scala.jdk.CollectionConverters.*
final case class DescribeOpsItemsRequest(
    opsItemFilters: Optional[Iterable[zio.aws.ssm.model.OpsItemFilter]] =
      Optional.Absent,
    maxResults: Optional[OpsItemMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest = {
    import DescribeOpsItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest
      .builder()
      .optionallyWith(
        opsItemFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.opsItemFilters)
      .optionallyWith(
        maxResults.map(value => OpsItemMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeOpsItemsRequest.ReadOnly =
    zio.aws.ssm.model.DescribeOpsItemsRequest.wrap(buildAwsValue())
}
object DescribeOpsItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeOpsItemsRequest =
      zio.aws.ssm.model.DescribeOpsItemsRequest(
        opsItemFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def opsItemFilters: Optional[List[zio.aws.ssm.model.OpsItemFilter.ReadOnly]]
    def maxResults: Optional[OpsItemMaxResults]
    def nextToken: Optional[String]
    def getOpsItemFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.OpsItemFilter.ReadOnly]] =
      AwsError.unwrapOptionField("opsItemFilters", opsItemFilters)
    def getMaxResults: ZIO[Any, AwsError, OpsItemMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest
  ) extends zio.aws.ssm.model.DescribeOpsItemsRequest.ReadOnly {
    override val opsItemFilters
        : Optional[List[zio.aws.ssm.model.OpsItemFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.opsItemFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsItemFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[OpsItemMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.OpsItemMaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest
  ): zio.aws.ssm.model.DescribeOpsItemsRequest.ReadOnly = new Wrapper(impl)
}
