package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait SignalType {
  def unwrap: software.amazon.awssdk.services.ssm.model.SignalType
}
object SignalType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.SignalType
  ): zio.aws.ssm.model.SignalType = value match {
    case software.amazon.awssdk.services.ssm.model.SignalType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.SignalType.APPROVE =>
      val r = Approve
      r
    case software.amazon.awssdk.services.ssm.model.SignalType.REJECT =>
      val r = Reject
      r
    case software.amazon.awssdk.services.ssm.model.SignalType.START_STEP =>
      val r = StartStep
      r
    case software.amazon.awssdk.services.ssm.model.SignalType.STOP_STEP =>
      val r = StopStep
      r
    case software.amazon.awssdk.services.ssm.model.SignalType.RESUME =>
      val r = Resume
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.SignalType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.SignalType =
      software.amazon.awssdk.services.ssm.model.SignalType.UNKNOWN_TO_SDK_VERSION
  }
  case object Approve extends zio.aws.ssm.model.SignalType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.SignalType =
      software.amazon.awssdk.services.ssm.model.SignalType.APPROVE
  }
  case object Reject extends zio.aws.ssm.model.SignalType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.SignalType =
      software.amazon.awssdk.services.ssm.model.SignalType.REJECT
  }
  case object StartStep extends zio.aws.ssm.model.SignalType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.SignalType =
      software.amazon.awssdk.services.ssm.model.SignalType.START_STEP
  }
  case object StopStep extends zio.aws.ssm.model.SignalType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.SignalType =
      software.amazon.awssdk.services.ssm.model.SignalType.STOP_STEP
  }
  case object Resume extends zio.aws.ssm.model.SignalType {
    override def unwrap: software.amazon.awssdk.services.ssm.model.SignalType =
      software.amazon.awssdk.services.ssm.model.SignalType.RESUME
  }
}
