package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait OpsItemFilterKey {
  def unwrap: software.amazon.awssdk.services.ssm.model.OpsItemFilterKey
}
object OpsItemFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.OpsItemFilterKey
  ): zio.aws.ssm.model.OpsItemFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.STATUS =>
      val r = Status
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CREATED_BY =>
      val r = CreatedBy
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.SOURCE =>
      val r = Source
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.PRIORITY =>
      val r = Priority
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.TITLE =>
      val r = Title
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.OPS_ITEM_ID =>
      val r = OpsItemId
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CREATED_TIME =>
      val r = CreatedTime
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.LAST_MODIFIED_TIME =>
      val r = LastModifiedTime
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.ACTUAL_START_TIME =>
      val r = ActualStartTime
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.ACTUAL_END_TIME =>
      val r = ActualEndTime
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.PLANNED_START_TIME =>
      val r = PlannedStartTime
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.PLANNED_END_TIME =>
      val r = PlannedEndTime
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.OPERATIONAL_DATA =>
      val r = OperationalData
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.OPERATIONAL_DATA_KEY =>
      val r = OperationalDataKey
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.OPERATIONAL_DATA_VALUE =>
      val r = OperationalDataValue
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.RESOURCE_ID =>
      val r = ResourceId
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.AUTOMATION_ID =>
      val r = AutomationId
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CATEGORY =>
      val r = Category
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.SEVERITY =>
      val r = Severity
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.OPS_ITEM_TYPE =>
      val r = OpsItemType
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CHANGE_REQUEST_BY_REQUESTER_ARN =>
      val r = ChangeRequestByRequesterArn
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CHANGE_REQUEST_BY_REQUESTER_NAME =>
      val r = ChangeRequestByRequesterName
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CHANGE_REQUEST_BY_APPROVER_ARN =>
      val r = ChangeRequestByApproverArn
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CHANGE_REQUEST_BY_APPROVER_NAME =>
      val r = ChangeRequestByApproverName
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CHANGE_REQUEST_BY_TEMPLATE =>
      val r = ChangeRequestByTemplate
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CHANGE_REQUEST_BY_TARGETS_RESOURCE_GROUP =>
      val r = ChangeRequestByTargetsResourceGroup
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.INSIGHT_BY_TYPE =>
      val r = InsightByType
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.ACCOUNT_ID =>
      val r = AccountId
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object Status extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.STATUS
  }
  case object CreatedBy extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CREATED_BY
  }
  case object Source extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.SOURCE
  }
  case object Priority extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.PRIORITY
  }
  case object Title extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.TITLE
  }
  case object OpsItemId extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.OPS_ITEM_ID
  }
  case object CreatedTime extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CREATED_TIME
  }
  case object LastModifiedTime extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.LAST_MODIFIED_TIME
  }
  case object ActualStartTime extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.ACTUAL_START_TIME
  }
  case object ActualEndTime extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.ACTUAL_END_TIME
  }
  case object PlannedStartTime extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.PLANNED_START_TIME
  }
  case object PlannedEndTime extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.PLANNED_END_TIME
  }
  case object OperationalData extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.OPERATIONAL_DATA
  }
  case object OperationalDataKey extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.OPERATIONAL_DATA_KEY
  }
  case object OperationalDataValue extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.OPERATIONAL_DATA_VALUE
  }
  case object ResourceId extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.RESOURCE_ID
  }
  case object AutomationId extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.AUTOMATION_ID
  }
  case object Category extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CATEGORY
  }
  case object Severity extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.SEVERITY
  }
  case object OpsItemType extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.OPS_ITEM_TYPE
  }
  case object ChangeRequestByRequesterArn
      extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CHANGE_REQUEST_BY_REQUESTER_ARN
  }
  case object ChangeRequestByRequesterName
      extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CHANGE_REQUEST_BY_REQUESTER_NAME
  }
  case object ChangeRequestByApproverArn
      extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CHANGE_REQUEST_BY_APPROVER_ARN
  }
  case object ChangeRequestByApproverName
      extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CHANGE_REQUEST_BY_APPROVER_NAME
  }
  case object ChangeRequestByTemplate
      extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CHANGE_REQUEST_BY_TEMPLATE
  }
  case object ChangeRequestByTargetsResourceGroup
      extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.CHANGE_REQUEST_BY_TARGETS_RESOURCE_GROUP
  }
  case object InsightByType extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.INSIGHT_BY_TYPE
  }
  case object AccountId extends zio.aws.ssm.model.OpsItemFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterKey.ACCOUNT_ID
  }
}
