package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait DescribeActivationsFilterKeys {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys
}
object DescribeActivationsFilterKeys {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys
  ): zio.aws.ssm.model.DescribeActivationsFilterKeys = value match {
    case software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys.ACTIVATION_IDS =>
      val r = ActivationIds
      r
    case software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys.DEFAULT_INSTANCE_NAME =>
      val r = DefaultInstanceName
      r
    case software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys.IAM_ROLE =>
      val r = IamRole
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.DescribeActivationsFilterKeys {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys =
      software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys.UNKNOWN_TO_SDK_VERSION
  }
  case object ActivationIds
      extends zio.aws.ssm.model.DescribeActivationsFilterKeys {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys =
      software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys.ACTIVATION_IDS
  }
  case object DefaultInstanceName
      extends zio.aws.ssm.model.DescribeActivationsFilterKeys {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys =
      software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys.DEFAULT_INSTANCE_NAME
  }
  case object IamRole extends zio.aws.ssm.model.DescribeActivationsFilterKeys {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys =
      software.amazon.awssdk.services.ssm.model.DescribeActivationsFilterKeys.IAM_ROLE
  }
}
