package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDocumentResponse(
    documentDescription: Optional[zio.aws.ssm.model.DocumentDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateDocumentResponse = {
    import CreateDocumentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateDocumentResponse
      .builder()
      .optionallyWith(documentDescription.map(value => value.buildAwsValue()))(
        _.documentDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateDocumentResponse.ReadOnly =
    zio.aws.ssm.model.CreateDocumentResponse.wrap(buildAwsValue())
}
object CreateDocumentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateDocumentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateDocumentResponse =
      zio.aws.ssm.model.CreateDocumentResponse(
        documentDescription.map(value => value.asEditable)
      )
    def documentDescription
        : Optional[zio.aws.ssm.model.DocumentDescription.ReadOnly]
    def getDocumentDescription
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentDescription.ReadOnly] =
      AwsError.unwrapOptionField("documentDescription", documentDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateDocumentResponse
  ) extends zio.aws.ssm.model.CreateDocumentResponse.ReadOnly {
    override val documentDescription
        : Optional[zio.aws.ssm.model.DocumentDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentDescription())
        .map(value => zio.aws.ssm.model.DocumentDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateDocumentResponse
  ): zio.aws.ssm.model.CreateDocumentResponse.ReadOnly = new Wrapper(impl)
}
