package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  RegistrationMetadataValue,
  RegistrationMetadataKey
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegistrationMetadataItem(
    key: RegistrationMetadataKey,
    value: RegistrationMetadataValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RegistrationMetadataItem = {
    import RegistrationMetadataItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RegistrationMetadataItem
      .builder()
      .key(RegistrationMetadataKey.unwrap(key): java.lang.String)
      .value(RegistrationMetadataValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.RegistrationMetadataItem.ReadOnly =
    zio.aws.ssm.model.RegistrationMetadataItem.wrap(buildAwsValue())
}
object RegistrationMetadataItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RegistrationMetadataItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.RegistrationMetadataItem =
      zio.aws.ssm.model.RegistrationMetadataItem(key, value)
    def key: RegistrationMetadataKey
    def value: RegistrationMetadataValue
    def getKey: ZIO[Any, Nothing, RegistrationMetadataKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, RegistrationMetadataValue] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RegistrationMetadataItem
  ) extends zio.aws.ssm.model.RegistrationMetadataItem.ReadOnly {
    override val key: RegistrationMetadataKey =
      zio.aws.ssm.model.primitives.RegistrationMetadataKey(impl.key())
    override val value: RegistrationMetadataValue =
      zio.aws.ssm.model.primitives.RegistrationMetadataValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RegistrationMetadataItem
  ): zio.aws.ssm.model.RegistrationMetadataItem.ReadOnly = new Wrapper(impl)
}
